/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.filter;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;

@Activate(group={"consumer"}, order=-1)
public class ContextHolderParametersSelectedTransferFilter
implements ClusterFilter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        this.setSecurityContextIfExists(invocation);
        return invoker.invoke(invocation);
    }

    private void setSecurityContextIfExists(Invocation invocation) {
        Map resultMap = RpcContext.getServerAttachment().getObjectAttachments();
        Object authentication = resultMap.get("security_authentication_context");
        if (Objects.isNull(authentication)) {
            return;
        }
        invocation.setObjectAttachment("security_authentication_context", authentication);
    }
}

