/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodec;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Activate(group={"consumer"}, order=-10000, onClass={"org.springframework.security.core.context.SecurityContextHolder", "org.springframework.security.jackson2.CoreJackson2Module", "com.fasterxml.jackson.databind.ObjectMapper"})
public class ContextHolderAuthenticationPrepareFilter
implements ClusterFilter {
    private final ObjectMapperCodec mapper;

    public ContextHolderAuthenticationPrepareFilter(ApplicationModel applicationModel) {
        this.mapper = (ObjectMapperCodec)applicationModel.getBeanFactory().getBean(ObjectMapperCodec.class);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.setSecurityContext(invocation);
        return invoker.invoke(invocation);
    }

    private void setSecurityContext(Invocation invocation) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        String content = this.mapper.serialize(authentication);
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        invocation.setObjectAttachment("security_authentication_context", (Object)content);
    }
}

