/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.observability.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingAwareMeterObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Arrays;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.protocol.QosProtocolWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.boot.observability.autoconfigure.DubboMicrometerTracingAutoConfiguration;
import org.apache.dubbo.spring.boot.observability.autoconfigure.ObservationHandlerGrouping;
import org.apache.dubbo.spring.boot.observability.autoconfigure.ObservationRegistryPostProcessor;
import org.apache.dubbo.spring.boot.observability.autoconfigure.annotation.ConditionalOnDubboTracingEnable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={DubboMicrometerTracingAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnDubboTracingEnable
@ConditionalOnClass(name={"io.micrometer.observation.Observation", "io.micrometer.tracing.Tracer"})
public class DubboObservationAutoConfiguration
implements BeanFactoryAware,
SmartInitializingSingleton {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(QosProtocolWrapper.class);
    private final ApplicationModel applicationModel;
    private BeanFactory beanFactory;

    public DubboObservationAutoConfiguration(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"io.micrometer.observation.ObservationRegistry"})
    ObservationRegistry observationRegistry() {
        return ObservationRegistry.create();
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor"})
    @ConditionalOnClass(name={"io.micrometer.observation.ObservationHandler"})
    public ObservationRegistryPostProcessor dubboObservationRegistryPostProcessor(ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping, ObjectProvider<ObservationHandler<?>> observationHandlers) {
        return new ObservationRegistryPostProcessor(observationHandlerGrouping, observationHandlers);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        try {
            this.applicationModel.getBeanFactory().registerBean(this.beanFactory.getBean(ObservationRegistry.class));
            Tracer bean = (Tracer)this.beanFactory.getBean(Tracer.class);
            this.applicationModel.getBeanFactory().registerBean((Object)bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.info("Please use a version of micrometer higher than 1.10.0 \uff1a{}" + e.getMessage());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={MeterObservationHandler.class})
    static class MeterObservationHandlerConfiguration {
        MeterObservationHandlerConfiguration() {
        }

        @ConditionalOnBean(value={Tracer.class})
        @Configuration(proxyBeanMethods=false)
        static class TracingAndMetricsObservationHandlerConfiguration {
            TracingAndMetricsObservationHandlerConfiguration() {
            }

            @Bean
            @ConditionalOnClass(name={"io.micrometer.tracing.handler.TracingAwareMeterObservationHandler", "io.micrometer.tracing.Tracer"})
            TracingAwareMeterObservationHandler<Observation.Context> tracingAwareMeterObservationHandler(MeterRegistry meterRegistry, Tracer tracer) {
                DefaultMeterObservationHandler delegate = new DefaultMeterObservationHandler(meterRegistry);
                return new TracingAwareMeterObservationHandler((MeterObservationHandler)delegate, tracer);
            }
        }

        @ConditionalOnMissingBean(type={"io.micrometer.tracing.Tracer"})
        @Configuration(proxyBeanMethods=false)
        static class OnlyMetricsMeterObservationHandlerConfiguration {
            OnlyMetricsMeterObservationHandlerConfiguration() {
            }

            @Bean
            @ConditionalOnClass(name={"io.micrometer.core.instrument.observation.DefaultMeterObservationHandler"})
            DefaultMeterObservationHandler defaultMeterObservationHandler(MeterRegistry meterRegistry) {
                return new DefaultMeterObservationHandler(meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class, Tracer.class})
    @ConditionalOnMissingBean(type={"org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor"})
    static class MetricsWithTracingConfiguration {
        MetricsWithTracingConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"io.micrometer.tracing.handler.TracingObservationHandler", "io.micrometer.core.instrument.observation.MeterObservationHandler"})
        ObservationHandlerGrouping metricsAndTracingObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(Arrays.asList(TracingObservationHandler.class, MeterObservationHandler.class));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry"})
    @ConditionalOnMissingBean(type={"org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor"})
    static class OnlyTracingConfiguration {
        OnlyTracingConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"io.micrometer.tracing.handler.TracingObservationHandler"})
        ObservationHandlerGrouping tracingObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(TracingObservationHandler.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.Tracer"})
    @ConditionalOnMissingBean(type={"org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor"})
    static class OnlyMetricsConfiguration {
        OnlyMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"io.micrometer.core.instrument.observation.MeterObservationHandler"})
        ObservationHandlerGrouping metricsObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(MeterObservationHandler.class);
        }
    }
}

