/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin;

import org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin.HttpSender;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import zipkin2.Call;
import zipkin2.Callback;

class ZipkinWebClientSender
extends HttpSender {
    private final String endpoint;
    private final WebClient webClient;

    ZipkinWebClientSender(String endpoint, WebClient webClient) {
        this.endpoint = endpoint;
        this.webClient = webClient;
    }

    @Override
    public HttpSender.HttpPostCall sendSpans(byte[] batchedEncodedSpans) {
        return new WebClientHttpPostCall(this.endpoint, batchedEncodedSpans, this.webClient);
    }

    private static class WebClientHttpPostCall
    extends HttpSender.HttpPostCall {
        private final String endpoint;
        private final WebClient webClient;

        WebClientHttpPostCall(String endpoint, byte[] body, WebClient webClient) {
            super(body);
            this.endpoint = endpoint;
            this.webClient = webClient;
        }

        public Call<Void> clone() {
            return new WebClientHttpPostCall(this.endpoint, this.getUncompressedBody(), this.webClient);
        }

        protected Void doExecute() {
            this.sendRequest().block();
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            this.sendRequest().subscribe(entity -> callback.onSuccess(null), arg_0 -> callback.onError(arg_0));
        }

        private Mono<ResponseEntity<Void>> sendRequest() {
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.endpoint, new Object[0])).headers(this::addDefaultHeaders)).bodyValue((Object)this.getBody()).retrieve().toBodilessEntity();
        }

        private void addDefaultHeaders(HttpHeaders headers) {
            headers.addAll((MultiValueMap)this.getDefaultHeaders());
        }
    }
}

