/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fst;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.fst.FstFactory;
import org.nustaq.serialization.FSTObjectOutput;

public class FstObjectOutput
implements ObjectOutput {
    private FSTObjectOutput output;

    public FstObjectOutput(OutputStream outputStream) {
        this.output = FstFactory.getDefaultFactory().getObjectOutput(outputStream);
    }

    public void writeBool(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.output.writeByte((int)v);
    }

    public void writeShort(short v) throws IOException {
        this.output.writeShort((int)v);
    }

    public void writeInt(int v) throws IOException {
        this.output.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.output.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.output.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.output.writeDouble(v);
    }

    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.output.writeInt(-1);
        } else {
            this.writeBytes(v, 0, v.length);
        }
    }

    public void writeBytes(byte[] v, int off, int len) throws IOException {
        if (v == null) {
            this.output.writeInt(-1);
        } else {
            this.output.writeInt(len);
            this.output.write(v, off, len);
        }
    }

    public void writeUTF(String v) throws IOException {
        this.output.writeUTF(v);
    }

    public void writeObject(Object v) throws IOException {
        this.output.writeObject(v);
    }

    public void flushBuffer() throws IOException {
        this.output.flush();
    }
}

