/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

public class NamedValueMeta {
    private String name;
    private final boolean required;
    private final String defaultValue;
    private Class<?> type;
    private Type genericType;
    private Class<?>[] nestedTypes;
    private ParameterMeta parameterMeta;

    public NamedValueMeta(String name, boolean required, String defaultValue) {
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public NamedValueMeta(boolean required, String defaultValue) {
        this.name = null;
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public String name() {
        if (this.name == null) {
            throw new RestException(Messages.ARGUMENT_NAME_MISSING, this.type);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameEmpty() {
        return StringUtils.isEmpty((String)this.name);
    }

    public boolean required() {
        return this.required;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Class<?> type() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Type genericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public Class<?> nestedType() {
        return this.nestedTypes == null ? null : this.nestedTypes[0];
    }

    public Class<?> nestedType(int index) {
        return this.nestedTypes == null || this.nestedTypes.length <= index ? null : this.nestedTypes[index];
    }

    public Class<?>[] nestedTypes() {
        return this.nestedTypes;
    }

    public void setNestedTypes(Class<?>[] nestedTypes) {
        this.nestedTypes = nestedTypes;
    }

    public ParameterMeta parameterMeta() {
        return this.parameterMeta;
    }

    public void setParameterMeta(ParameterMeta parameterMeta) {
        this.parameterMeta = parameterMeta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NamedValueMeta{name='");
        sb.append(this.name).append('\'');
        if (this.required) {
            sb.append(", required=true");
        }
        if (this.defaultValue != null) {
            sb.append(", defaultValue='").append(this.defaultValue).append('\'');
        }
        if (this.type != null) {
            sb.append(", type=").append(this.type);
            if (this.genericType != this.type) {
                sb.append(", genericType=").append(this.genericType);
            }
        }
        if (this.nestedTypes != null) {
            sb.append(", nestedTypes=").append(Arrays.toString(this.nestedTypes));
        }
        sb.append('}');
        return sb.toString();
    }
}

