/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;
import org.apache.dubbo.rpc.protocol.tri.rest.util.KeyString;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;

public final class RadixTree<T> {
    private final Map<KeyString, List<Match<T>>> directPathMap = new HashMap<KeyString, List<Match<T>>>();
    private final Node<T> root = new Node();
    private final boolean caseSensitive;

    public RadixTree(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public RadixTree() {
        this.caseSensitive = true;
    }

    public T addPath(PathExpression path, T value) {
        if (path.isDirect()) {
            KeyString key = new KeyString(path.getPath(), this.caseSensitive);
            List matches = this.directPathMap.computeIfAbsent(key, k -> new ArrayList());
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                Match match = (Match)matches.get(i);
                if (!match.getValue().equals(value)) continue;
                return match.getValue();
            }
            matches.add(new Match(path, (Object)value));
            return null;
        }
        Node<T> current = this.root;
        PathSegment[] segments = path.getSegments();
        int len = segments.length;
        for (int i = 0; i < len; ++i) {
            Node<T> child = this.getChild(current, segments[i]);
            if (i == len - 1) {
                List values = ((Node)child).values;
                int size = values.size();
                for (int j = 0; j < size; ++j) {
                    if (!((PathExpression)((Pair)values.get(j)).getLeft()).equals(path)) continue;
                    return (T)((Pair)values.get(j)).getRight();
                }
                values.add(Pair.of((Object)path, value));
            }
            current = child;
        }
        return null;
    }

    public T addPath(String path, T value) {
        return this.addPath(PathExpression.parse(PathUtils.normalize(path)), value);
    }

    private Node<T> getChild(Node<T> current, PathSegment segment) {
        Node child;
        if (segment.getType() == PathSegment.Type.LITERAL) {
            KeyString key;
            Map children = ((Node)current).children;
            child = (Node)children.get(key = new KeyString(segment.getValue(), this.caseSensitive));
            if (child == null) {
                child = new Node();
                children.put(key, child);
            }
        } else {
            Map children = ((Node)current).fuzzyChildren;
            child = (Node)children.get(segment);
            if (child == null) {
                child = new Node();
                children.put(segment, child);
            }
        }
        return child;
    }

    public void remove(Predicate<T> tester) {
        this.directPathMap.entrySet().removeIf(entry -> {
            List values = (List)entry.getValue();
            values.removeIf(match -> tester.test(match.getValue()));
            return values.isEmpty();
        });
        this.removeRecursive(this.root, tester);
    }

    private void removeRecursive(Node<T> current, Predicate<T> tester) {
        ((Node)current).values.removeIf(pair -> tester.test(pair.getValue()));
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(((Node)current).children);
        list.add(((Node)current).fuzzyChildren);
        for (Map children : list) {
            Iterator cit = children.entrySet().iterator();
            while (cit.hasNext()) {
                Node node = (Node)cit.next().getValue();
                this.removeRecursive(node, tester);
                if (!node.isEmpty()) continue;
                cit.remove();
            }
        }
    }

    public void match(KeyString path, List<Match<T>> matches) {
        List<Match<T>> directMatches = this.directPathMap.get(path);
        if (directMatches != null) {
            int size = directMatches.size();
            for (int i = 0; i < size; ++i) {
                matches.add(directMatches.get(i));
            }
        }
        if (((Node)this.root).isLeaf()) {
            return;
        }
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
    }

    public void match(String path, List<Match<T>> matches) {
        this.match(new KeyString(path, this.caseSensitive), matches);
    }

    public List<Match<T>> match(KeyString path) {
        List<Match<T>> matches = this.directPathMap.get(path);
        if (matches == null) {
            if (((Node)this.root).isLeaf()) {
                return Collections.emptyList();
            }
            matches = new ArrayList<Match<T>>();
        } else {
            if (((Node)this.root).isLeaf()) {
                return Collections.unmodifiableList(matches);
            }
            matches = new ArrayList<Match<T>>(matches);
        }
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
        return matches;
    }

    public List<Match<T>> match(String path) {
        return this.match(new KeyString(path, this.caseSensitive));
    }

    private void matchRecursive(Node<T> current, KeyString path, int start, Map<String, String> variableMap, List<Match<T>> matches) {
        int end = -2;
        if (!((Node)current).children.isEmpty()) {
            end = path.indexOf('/', start);
            Node node = (Node)((Node)current).children.get(path.subSequence(start, end));
            if (node != null) {
                if (end == -1) {
                    if (node.isLeaf()) {
                        RadixTree.addMatch(node, variableMap, matches);
                    }
                    return;
                }
                this.matchRecursive(node, path, end + 1, variableMap, matches);
            }
        }
        if (((Node)current).fuzzyChildren.isEmpty()) {
            return;
        }
        if (end == -2) {
            end = path.indexOf('/', start);
        }
        LinkedHashMap<String, String> workVariableMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : ((Node)current).fuzzyChildren.entrySet()) {
            PathSegment segment = (PathSegment)entry.getKey();
            if (!segment.match(path, start, end, workVariableMap)) continue;
            workVariableMap.putAll(variableMap);
            Node child = (Node)entry.getValue();
            if (segment.isTailMatching()) {
                RadixTree.addMatch(child, workVariableMap, matches);
            } else if (end == -1) {
                if (child.isLeaf()) {
                    RadixTree.addMatch(child, workVariableMap, matches);
                }
            } else {
                this.matchRecursive(child, path, end + 1, workVariableMap, matches);
            }
            if (workVariableMap.isEmpty()) continue;
            workVariableMap = new LinkedHashMap();
        }
    }

    private static <T> void addMatch(Node<T> node, Map<String, String> variableMap, List<Match<T>> matches) {
        List values = ((Node)node).values;
        variableMap = variableMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(variableMap);
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)values.get(i);
            matches.add(new Match<Object>((PathExpression)pair.getLeft(), pair.getRight(), variableMap));
        }
    }

    public void clear() {
        this.directPathMap.clear();
        ((Node)this.root).clear();
    }

    public boolean isEmpty() {
        return this.directPathMap.isEmpty() && ((Node)this.root).isEmpty();
    }

    private static final class Node<T> {
        private final Map<KeyString, Node<T>> children = new HashMap<KeyString, Node<T>>();
        private final Map<PathSegment, Node<T>> fuzzyChildren = new HashMap<PathSegment, Node<T>>();
        private final List<Pair<PathExpression, T>> values = new ArrayList<Pair<PathExpression, T>>();

        private Node() {
        }

        private boolean isLeaf() {
            return this.children.isEmpty() && this.fuzzyChildren.isEmpty();
        }

        private boolean isEmpty() {
            return this.isLeaf() && this.values.isEmpty();
        }

        private void clear() {
            this.children.clear();
            this.fuzzyChildren.clear();
            this.values.clear();
        }
    }

    public static final class Match<T>
    implements Comparable<Match<T>> {
        private final PathExpression expression;
        private final T value;
        private final Map<String, String> variableMap;

        Match(PathExpression expression, T value, Map<String, String> variableMap) {
            this.expression = expression;
            this.value = value;
            this.variableMap = variableMap;
        }

        private Match(PathExpression expression, T value) {
            this.expression = expression;
            this.value = value;
            this.variableMap = Collections.emptyMap();
        }

        public PathExpression getExpression() {
            return this.expression;
        }

        public T getValue() {
            return this.value;
        }

        public Map<String, String> getVariableMap() {
            return this.variableMap;
        }

        @Override
        public int compareTo(Match<T> other) {
            int comparison = this.expression.compareTo(other.getExpression());
            return comparison == 0 ? this.variableMap.size() - other.variableMap.size() : comparison;
        }
    }
}

