/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.cors;

import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.CorsConfig;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;

public class CorsUtils {
    private CorsUtils() {
    }

    public static CorsMeta getGlobalCorsMeta(FrameworkModel frameworkModel) {
        CorsConfig config = ConfigManager.getProtocolOrDefault((String)"tri").getTripleOrDefault().getRestOrDefault().getCorsOrDefault();
        return CorsMeta.builder().allowedOrigins(config.getAllowedOrigins()).allowedMethods(config.getAllowedMethods()).allowedHeaders(config.getAllowedHeaders()).allowCredentials(config.getAllowCredentials()).exposedHeaders(config.getExposedHeaders()).maxAge(config.getMaxAge()).build();
    }

    private static String[] getValues(Configuration config, String key) {
        return StringUtils.tokenize((String)config.getString(key), (char[])new char[]{','});
    }

    public static String formatOrigin(String value) {
        int last = (value = value.trim()).length() - 1;
        return last > -1 && value.charAt(last) == '/' ? value.substring(0, last) : value;
    }
}

