/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest;

import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;

public class RestException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final Messages message;
    private final String displayMessage;

    public RestException(String message) {
        super(500, message);
        this.message = Messages.INTERNAL_ERROR;
        this.displayMessage = null;
    }

    public RestException(Throwable cause) {
        super(500, ExceptionUtils.unwrap(cause));
        this.message = Messages.INTERNAL_ERROR;
        this.displayMessage = null;
    }

    public RestException(String message, Throwable cause) {
        super(500, message, ExceptionUtils.unwrap(cause));
        this.message = Messages.INTERNAL_ERROR;
        this.displayMessage = null;
    }

    public RestException(Messages message, Object ... arguments) {
        super(message.statusCode(), message.format(arguments));
        this.message = message;
        this.displayMessage = message.formatDisplay(arguments);
    }

    public RestException(Throwable cause, Messages message, Object ... arguments) {
        super(message.statusCode(), message.format(arguments), ExceptionUtils.unwrap(cause));
        this.message = message;
        this.displayMessage = message.formatDisplay(arguments);
    }

    public String getErrorCode() {
        return this.message.name();
    }

    public String getDisplayMessage() {
        return this.displayMessage == null ? this.getMessage() : this.displayMessage;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": status=" + this.getStatusCode() + ", " + this.getErrorCode() + ", " + this.getMessage();
    }
}

