/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http1;

import io.netty.buffer.ByteBufOutputStream;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;

public final class Http1UnaryServerChannelObserver
extends Http1ServerChannelObserver {
    public Http1UnaryServerChannelObserver(HttpChannel httpChannel) {
        super(httpChannel);
    }

    protected void doOnNext(Object data) throws Throwable {
        int statusCode = this.resolveStatusCode(data);
        HttpOutputMessage message = this.buildMessage(statusCode, data);
        this.sendMetadata(this.buildMetadata(statusCode, data, null, message));
        this.sendMessage(message);
    }

    protected void doOnError(Throwable throwable) throws Throwable {
        int statusCode = this.resolveErrorStatusCode(throwable);
        ErrorResponse data = this.buildErrorResponse(statusCode, throwable);
        HttpOutputMessage message = this.buildMessage(statusCode, data);
        this.sendMetadata(this.buildMetadata(statusCode, data, throwable, message));
        this.sendMessage(message);
    }

    protected void customizeHeaders(HttpHeaders headers, Throwable throwable, HttpOutputMessage message) {
        super.customizeHeaders(headers, throwable, message);
        int contentLength = message == null ? 0 : ((ByteBufOutputStream)message.getBody()).writtenBytes();
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH.getName(), String.valueOf(contentLength));
    }

    protected Throwable customizeError(Throwable throwable) {
        if ((throwable = super.customizeError(throwable)) == null) {
            this.doOnCompleted(null);
        }
        return throwable;
    }

    protected String getDisplayMessage(Throwable throwable) {
        return TripleProtocol.VERBOSE_ENABLED ? ExceptionUtils.buildVerboseMessage(throwable) : super.getDisplayMessage(throwable);
    }
}

