/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.RequestPath;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodecFactory;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;

@Activate(order=-3000)
public final class GrpcRequestHandlerMapping
implements RequestHandlerMapping {
    public static final GrpcCompositeCodecFactory CODEC_FACTORY = new GrpcCompositeCodecFactory();
    private final FrameworkModel frameworkModel;
    private final PathResolver pathResolver;

    public GrpcRequestHandlerMapping(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
    }

    @Override
    public RequestHandler getRequestHandler(URL url, HttpRequest request, HttpResponse response) {
        if (!GrpcUtils.isGrpcRequest(request.contentType())) {
            return null;
        }
        RequestPath path = RequestPath.parse(request.uri());
        if (path == null) {
            throw GrpcRequestHandlerMapping.notFound();
        }
        String group = request.header(TripleHeaderEnum.SERVICE_GROUP.getKey());
        String version = request.header(TripleHeaderEnum.SERVICE_VERSION.getKey());
        Invoker invoker = this.pathResolver.resolve(path.getPath(), group, version);
        if (invoker == null) {
            throw GrpcRequestHandlerMapping.notFound();
        }
        RequestHandler handler = new RequestHandler(invoker);
        handler.setHasStub(this.pathResolver.hasNativeStub(path.getStubPath()));
        handler.setMethodName(path.getMethodName());
        String serviceName = path.getServiceInterface();
        handler.setServiceDescriptor(DescriptorUtils.findServiceDescriptor(invoker, serviceName, handler.isHasStub()));
        HttpMessageCodec codec = CODEC_FACTORY.createCodec(url, this.frameworkModel, request.contentType());
        handler.setHttpMessageDecoder((HttpMessageDecoder)codec);
        handler.setHttpMessageEncoder((HttpMessageEncoder)codec);
        return handler;
    }

    private static HttpStatusException notFound() {
        return new HttpStatusException(HttpStatus.NOT_FOUND.getCode(), "Invoker for gRPC not found");
    }

    @Override
    public String getType() {
        return "grpc";
    }
}

