/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ByteBufferBackedChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpVersion;

public class TripleProtocolDetector
implements ProtocolDetector {
    public static final String HTTP_VERSION = "HTTP_VERSION";
    private static final ChannelBuffer CLIENT_PREFACE_STRING = new ByteBufferBackedChannelBuffer(Http2CodecUtil.connectionPrefaceBuf().nioBuffer());

    public ProtocolDetector.Result detect(ChannelBuffer in) {
        if (in.readableBytes() < 2) {
            return ProtocolDetector.Result.needMoreData();
        }
        byte[] magics = new byte[7];
        in.getBytes(in.readerIndex(), magics, 0, 7);
        if (TripleProtocolDetector.isHttp(magics)) {
            ProtocolDetector.Result recognized = ProtocolDetector.Result.recognized();
            recognized.setAttribute(HTTP_VERSION, HttpVersion.HTTP1.getVersion());
            return recognized;
        }
        in.resetReaderIndex();
        int prefaceLen = CLIENT_PREFACE_STRING.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals((ChannelBuffer)in, (ChannelBuffer)CLIENT_PREFACE_STRING, (int)bytesRead)) {
            return ProtocolDetector.Result.unrecognized();
        }
        if (bytesRead == prefaceLen) {
            ProtocolDetector.Result recognized = ProtocolDetector.Result.recognized();
            recognized.setAttribute(HTTP_VERSION, HttpVersion.HTTP2.getVersion());
            return recognized;
        }
        return ProtocolDetector.Result.needMoreData();
    }

    private static boolean isHttp(byte[] magic) {
        for (int i = 0; i < 8; ++i) {
            byte[] methodBytes = HttpMethods.HTTP_METHODS_BYTES[i];
            int end = methodBytes.length - 1;
            for (int j = 0; j <= end && magic[j] == methodBytes[j]; ++j) {
                if (j != end) continue;
                return true;
            }
        }
        return false;
    }
}

