/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.remoting.api.AbstractWireProtocol;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.ssl.ContextOperator;
import org.apache.dubbo.remoting.http12.HttpVersion;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1Codec;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1ConnectionHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameCodec;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2ProtocolSelectorHandler;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.tri.TriHttp2RemoteFlowController;
import org.apache.dubbo.rpc.protocol.tri.TripleHttp2FrameCodecBuilder;
import org.apache.dubbo.rpc.protocol.tri.TriplePingPongHandler;
import org.apache.dubbo.rpc.protocol.tri.h12.TripleProtocolDetector;
import org.apache.dubbo.rpc.protocol.tri.h12.http1.DefaultHttp11ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleGoAwayHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleTailHandler;

@Activate
public class TripleHttp2Protocol
extends AbstractWireProtocol
implements ScopeModelAware {
    public static final Http2FrameLogger CLIENT_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_CLIENT");
    public static final Http2FrameLogger SERVER_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_SERVER");
    private FrameworkModel frameworkModel;

    public TripleHttp2Protocol() {
        super((ProtocolDetector)new TripleProtocolDetector());
    }

    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public void close() {
        super.close();
    }

    public void configClientPipeline(URL url, ChannelOperator operator, ContextOperator contextOperator) {
        TripleConfig tripleConfig = ConfigManager.getProtocolOrDefault((URL)url).getTripleOrDefault();
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)tripleConfig.getHeaderTableSizeOrDefault()).pushEnabled(tripleConfig.getEnablePushOrDefault()).maxConcurrentStreams((long)tripleConfig.getMaxConcurrentStreamsOrDefault()).initialWindowSize(tripleConfig.getInitialWindowSizeOrDefault()).maxFrameSize(tripleConfig.getMaxFrameSizeOrDefault()).maxHeaderListSize((long)tripleConfig.getMaxHeaderListSizeOrDefault())).frameLogger(CLIENT_LOGGER).validateHeaders(false).build();
        ArrayList<ChannelHandlerPretender> handlers = new ArrayList<ChannelHandlerPretender>();
        handlers.add(new ChannelHandlerPretender((Object)codec));
        handlers.add(new ChannelHandlerPretender((Object)new Http2MultiplexHandler((ChannelHandler)new ChannelDuplexHandler())));
        handlers.add(new ChannelHandlerPretender((Object)new TriplePingPongHandler(UrlUtils.getCloseTimeout((URL)url))));
        handlers.add(new ChannelHandlerPretender((Object)new TripleGoAwayHandler()));
        handlers.add(new ChannelHandlerPretender((Object)new TripleTailHandler()));
        operator.configChannelHandler(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configServerProtocolHandler(URL url, ChannelOperator operator) {
        String httpVersion = operator.detectResult().getAttribute("HTTP_VERSION");
        ArrayList<org.apache.dubbo.remoting.ChannelHandler> channelHandlerPretenders = new ArrayList<org.apache.dubbo.remoting.ChannelHandler>();
        try {
            if (HttpVersion.HTTP1.getVersion().equals(httpVersion)) {
                this.configurerHttp1Handlers(url, channelHandlerPretenders);
                return;
            }
            if (HttpVersion.HTTP2.getVersion().equals(httpVersion)) {
                this.configurerHttp2Handlers(url, channelHandlerPretenders);
            }
        }
        finally {
            operator.configChannelHandler(channelHandlerPretenders);
        }
    }

    private void configurerHttp1Handlers(URL url, List<org.apache.dubbo.remoting.ChannelHandler> handlers) {
        TripleConfig tripleConfig = ConfigManager.getProtocolOrDefault((URL)url).getTripleOrDefault();
        HttpServerCodec sourceCodec = new HttpServerCodec(tripleConfig.getMaxInitialLineLengthOrDefault(), tripleConfig.getMaxHeaderSizeOrDefault(), tripleConfig.getMaxChunkSizeOrDefault(), false, tripleConfig.getInitialBufferSizeOrDefault());
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)sourceCodec));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(this.buildHttp2FrameCodec(tripleConfig), new ChannelHandler[]{new HttpWriteQueueHandler(), new FlushConsolidationHandler(64, true), new TripleServerConnectionHandler(), this.buildHttp2MultiplexHandler(url, tripleConfig), new TripleTailHandler()});
            }
            return null;
        }, Integer.MAX_VALUE)));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new HttpObjectAggregator(tripleConfig.getMaxBodySizeOrDefault())));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new NettyHttp1Codec()));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new NettyHttp1ConnectionHandler(url, this.frameworkModel, tripleConfig, DefaultHttp11ServerTransportListenerFactory.INSTANCE)));
    }

    private Http2MultiplexHandler buildHttp2MultiplexHandler(final URL url, final TripleConfig tripleConfig) {
        return new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new NettyHttp2FrameCodec()});
                p.addLast(new ChannelHandler[]{new NettyHttp2ProtocolSelectorHandler(url, TripleHttp2Protocol.this.frameworkModel, tripleConfig, GenericHttp2ServerTransportListenerFactory.INSTANCE)});
            }
        });
    }

    private void configurerHttp2Handlers(URL url, List<org.apache.dubbo.remoting.ChannelHandler> handlers) {
        TripleConfig tripleConfig = ConfigManager.getProtocolOrDefault((URL)url).getTripleOrDefault();
        Http2FrameCodec codec = this.buildHttp2FrameCodec(tripleConfig);
        Http2MultiplexHandler handler = this.buildHttp2MultiplexHandler(url, tripleConfig);
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new HttpWriteQueueHandler()));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)codec));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new FlushConsolidationHandler(64, true)));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new TripleServerConnectionHandler()));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)handler));
        handlers.add((org.apache.dubbo.remoting.ChannelHandler)new ChannelHandlerPretender((Object)new TripleTailHandler()));
    }

    private Http2FrameCodec buildHttp2FrameCodec(TripleConfig tripleConfig) {
        return TripleHttp2FrameCodecBuilder.forServer().customizeConnection(connection -> connection.remote().flowController((Http2FlowController)new TriHttp2RemoteFlowController((Http2Connection)connection, tripleConfig))).gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)tripleConfig.getHeaderTableSizeOrDefault()).maxConcurrentStreams((long)tripleConfig.getMaxConcurrentStreamsOrDefault()).initialWindowSize(tripleConfig.getInitialWindowSizeOrDefault()).maxFrameSize(tripleConfig.getMaxFrameSizeOrDefault()).maxHeaderListSize((long)tripleConfig.getMaxHeaderListSizeOrDefault())).frameLogger(SERVER_LOGGER).validateHeaders(false).build();
    }
}

