/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

public final class RequestPath {
    private final String path;
    private final String stubPath;
    private final String serviceInterface;
    private final String methodName;

    private RequestPath(String path, String stubPath, String serviceInterface, String methodName) {
        this.path = path;
        this.stubPath = stubPath;
        this.serviceInterface = serviceInterface;
        this.methodName = methodName;
    }

    public static RequestPath parse(String fullPath) {
        int i = fullPath.lastIndexOf(47);
        if (i < 1) {
            return null;
        }
        String path = fullPath.substring(1, i);
        int j = path.lastIndexOf(47);
        if (j == -1) {
            return new RequestPath(path, fullPath, path, fullPath.substring(i + 1));
        }
        return new RequestPath(path, fullPath.substring(j), path.substring(j + 1), fullPath.substring(i + 1));
    }

    public static String toFullPath(String path, String methodName) {
        return '/' + path + '/' + methodName;
    }

    public String getPath() {
        return this.path;
    }

    public String getStubPath() {
        return this.stubPath;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return this.path + '/' + this.methodName;
    }
}

