/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import org.apache.dubbo.common.ServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.rpc.executor.AbstractIsolationExecutorSupport;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class TripleIsolationExecutorSupport
extends AbstractIsolationExecutorSupport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TripleIsolationExecutorSupport.class);

    public TripleIsolationExecutorSupport(URL url) {
        super(url);
    }

    protected ServiceKey getServiceKey(Object data) {
        if (!(data instanceof Http2Header)) {
            return null;
        }
        Http2Header http2Metadata = (Http2Header)data;
        HttpHeaders headers = http2Metadata.headers();
        String path = http2Metadata.path();
        String[] parts = path.split("/");
        String interfaceName = parts[1];
        String version = headers.containsKey((Object)TripleHeaderEnum.SERVICE_VERSION.getHeader()) ? headers.getFirst(TripleHeaderEnum.SERVICE_VERSION.getHeader()) : null;
        String group = headers.containsKey((Object)TripleHeaderEnum.SERVICE_GROUP.getHeader()) ? headers.getFirst(TripleHeaderEnum.SERVICE_GROUP.getHeader()) : null;
        return new ServiceKey(interfaceName, version, group);
    }
}

