/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.logging.LogLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.remoting.api.AbstractWireProtocol;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.ssl.ContextOperator;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.tri.Http2ProtocolDetector;
import org.apache.dubbo.rpc.protocol.tri.TriHttp2RemoteFlowController;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleClientHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleCommandOutBoundHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleHttp2FrameServerHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleTailHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleWriteQueue;

@Activate
public class TripleHttp2Protocol
extends AbstractWireProtocol
implements ScopeModelAware {
    private static final int MIB_1 = 0x100000;
    private static final int MIB_8 = 0x800000;
    private static final int KIB_32 = 32768;
    private static final int DEFAULT_MAX_HEADER_LIST_SIZE = 32768;
    private static final int DEFAULT_SETTING_HEADER_LIST_SIZE = 4096;
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x800000;
    private static final int DEFAULT_WINDOW_INIT_SIZE = 0x800000;
    public static final Http2FrameLogger CLIENT_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_CLIENT");
    public static final Http2FrameLogger SERVER_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_SERVER");
    private ExtensionLoader<HeaderFilter> filtersLoader;
    private FrameworkModel frameworkModel;
    private Configuration config = ConfigurationUtils.getGlobalConfiguration((ScopeModel)ApplicationModel.defaultModel());

    public TripleHttp2Protocol() {
        super((ProtocolDetector)new Http2ProtocolDetector());
    }

    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.config = ConfigurationUtils.getGlobalConfiguration((ScopeModel)applicationModel);
        this.filtersLoader = applicationModel.getExtensionLoader(HeaderFilter.class);
    }

    public void close() {
        super.close();
    }

    public void configServerProtocolHandler(URL url, ChannelOperator operator) {
        final List headFilters = this.filtersLoader != null ? this.filtersLoader.getActivateExtension(url, "header.filter") : Collections.emptyList();
        Http2FrameCodec codec = Http2FrameCodecBuilder.forServer().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)this.config.getInt("dubbo.rpc.tri.header-table-size", 4096)).maxConcurrentStreams((long)this.config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(this.config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(this.config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)this.config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(SERVER_LOGGER).build();
        final ExecutorSupport executorSupport = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).getExecutorSupport(url);
        codec.connection().remote().flowController((Http2FlowController)new TriHttp2RemoteFlowController(codec.connection(), url.getOrDefaultApplicationModel()));
        ((Http2LocalFlowController)codec.connection().local().flowController()).frameWriter(codec.encoder().frameWriter());
        final TripleWriteQueue writeQueue = new TripleWriteQueue();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new TripleCommandOutBoundHandler()});
                p.addLast(new ChannelHandler[]{new TripleHttp2FrameServerHandler(TripleHttp2Protocol.this.frameworkModel, executorSupport, headFilters, ch, writeQueue)});
            }
        });
        ArrayList<ChannelHandlerPretender> handlers = new ArrayList<ChannelHandlerPretender>();
        handlers.add(new ChannelHandlerPretender((Object)codec));
        handlers.add(new ChannelHandlerPretender((Object)new TripleServerConnectionHandler()));
        handlers.add(new ChannelHandlerPretender((Object)handler));
        handlers.add(new ChannelHandlerPretender((Object)new TripleTailHandler()));
        operator.configChannelHandler(handlers);
    }

    public void configClientPipeline(URL url, ChannelOperator operator, ContextOperator contextOperator) {
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)this.config.getInt("dubbo.rpc.tri.header-table-size", 4096)).pushEnabled(this.config.getBoolean("dubbo.rpc.tri.enable-push", false)).maxConcurrentStreams((long)this.config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(this.config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(this.config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)this.config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(CLIENT_LOGGER).build();
        codec.connection().remote().flowController((Http2FlowController)new TriHttp2RemoteFlowController(codec.connection(), url.getOrDefaultApplicationModel()));
        ((Http2LocalFlowController)codec.connection().local().flowController()).frameWriter(codec.encoder().frameWriter());
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new TripleClientHandler(this.frameworkModel));
        ArrayList<ChannelHandlerPretender> handlers = new ArrayList<ChannelHandlerPretender>();
        handlers.add(new ChannelHandlerPretender((Object)codec));
        handlers.add(new ChannelHandlerPretender((Object)handler));
        handlers.add(new ChannelHandlerPretender((Object)new TripleTailHandler()));
        operator.configChannelHandler(handlers);
    }
}

