/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.TriRpcStatus;

public class DeadlineFuture
extends CompletableFuture<AppResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeadlineFuture.class);
    private final String serviceName;
    private final String methodName;
    private final String address;
    private final int timeout;
    private final long start = System.currentTimeMillis();
    private final List<Runnable> timeoutListeners = new ArrayList<Runnable>();
    private final Timeout timeoutTask;
    private ExecutorService executor;
    private static final GlobalResourceInitializer<Timer> TIME_OUT_TIMER = new GlobalResourceInitializer(() -> new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-future-timeout", true), 30L, TimeUnit.MILLISECONDS), DeadlineFuture::destroy);

    private DeadlineFuture(String serviceName, String methodName, String address, int timeout) {
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.address = address;
        this.timeout = timeout;
        TimeoutCheckTask timeoutCheckTask = new TimeoutCheckTask();
        this.timeoutTask = ((Timer)TIME_OUT_TIMER.get()).newTimeout((TimerTask)timeoutCheckTask, (long)timeout, TimeUnit.MILLISECONDS);
    }

    public static void destroy() {
        TIME_OUT_TIMER.remove(Timer::stop);
    }

    public static DeadlineFuture newFuture(String serviceName, String methodName, String address, int timeout, ExecutorService executor) {
        DeadlineFuture future = new DeadlineFuture(serviceName, methodName, address, timeout);
        future.setExecutor(executor);
        if (executor instanceof ThreadlessExecutor) {
            ((ThreadlessExecutor)executor).setWaitingFuture((CompletableFuture)future);
        }
        return future;
    }

    public void received(TriRpcStatus status, AppResponse appResponse) {
        if (status.code != TriRpcStatus.Code.DEADLINE_EXCEEDED && !this.timeoutTask.isCancelled()) {
            this.timeoutTask.cancel();
        }
        if (this.getExecutor() != null) {
            this.getExecutor().execute(() -> this.doReceived(status, appResponse));
        } else {
            this.doReceived(status, appResponse);
        }
    }

    public void addTimeoutListener(Runnable runnable) {
        this.timeoutListeners.add(runnable);
    }

    public List<Runnable> getTimeoutListeners() {
        return this.timeoutListeners;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.timeoutTask.cancel();
        this.doReceived(TriRpcStatus.CANCELLED, new AppResponse((Throwable)((Object)TriRpcStatus.CANCELLED.asException())));
        return true;
    }

    public void cancel() {
        this.cancel(true);
    }

    private void doReceived(TriRpcStatus status, AppResponse appResponse) {
        ThreadlessExecutor threadlessExecutor;
        if (this.isDone() || this.isCancelled() || this.isCompletedExceptionally()) {
            return;
        }
        this.complete(appResponse);
        if (this.executor != null && this.executor instanceof ThreadlessExecutor && (threadlessExecutor = (ThreadlessExecutor)this.executor).isWaiting()) {
            threadlessExecutor.notifyReturn((Throwable)new IllegalStateException("The result has returned, but the biz thread is still waiting which is not an expected state, interrupt the thread manually by returning an exception."));
        }
    }

    private String getTimeoutMessage() {
        long nowTimestamp = System.currentTimeMillis();
        return "Waiting server-side response timeout by scan timer. start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(nowTimestamp)) + ", timeout: " + this.timeout + " ms, service: " + this.serviceName + ", method: " + this.methodName;
    }

    private class TimeoutCheckTask
    implements TimerTask {
        private TimeoutCheckTask() {
        }

        public void run(Timeout timeout) {
            if (DeadlineFuture.this.isDone()) {
                return;
            }
            if (DeadlineFuture.this.getExecutor() != null) {
                DeadlineFuture.this.getExecutor().execute(() -> {
                    this.notifyTimeout();
                    for (Runnable timeoutListener : DeadlineFuture.this.getTimeoutListeners()) {
                        timeoutListener.run();
                    }
                });
            } else {
                this.notifyTimeout();
            }
        }

        private void notifyTimeout() {
            TriRpcStatus status = TriRpcStatus.DEADLINE_EXCEEDED.withDescription(DeadlineFuture.this.getTimeoutMessage());
            AppResponse timeoutResponse = new AppResponse();
            timeoutResponse.setException((Throwable)((Object)status.asException()));
            DeadlineFuture.this.doReceived(status, timeoutResponse);
        }
    }
}

