/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class WriteQueue {
    static final int DEQUE_CHUNK_SIZE = 128;
    private final Channel channel;
    private final Queue<QueuedCommand> queue;
    private final AtomicBoolean scheduled;
    private volatile boolean rst;

    public WriteQueue(Channel channel) {
        this.channel = channel;
        this.queue = new ConcurrentLinkedQueue<QueuedCommand>();
        this.scheduled = new AtomicBoolean(false);
    }

    public ChannelFuture success() {
        return this.channel.newSucceededFuture();
    }

    public ChannelFuture failure(Throwable cause) {
        return this.channel.newFailedFuture(cause);
    }

    public ChannelFuture enqueue(QueuedCommand command, boolean rst) {
        ChannelFuture future = this.enqueue(command);
        if (rst) {
            this.rst = true;
        }
        return future;
    }

    public ChannelFuture enqueue(QueuedCommand command) {
        if (!this.channel.isActive()) {
            return this.channel.newFailedFuture((Throwable)new IOException("channel is closed"));
        }
        if (this.rst) {
            return this.channel.newFailedFuture((Throwable)new IOException("channel has reset"));
        }
        ChannelPromise promise = command.promise();
        if (promise == null) {
            promise = this.channel.newPromise();
            command.promise(promise);
        }
        this.queue.add(command);
        this.scheduleFlush();
        return promise;
    }

    public void scheduleFlush() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.channel.eventLoop().execute(this::flush);
        }
    }

    public void close() {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        try {
            QueuedCommand cmd;
            int i = 0;
            boolean flushedOnce = false;
            while ((cmd = this.queue.poll()) != null) {
                cmd.run(this.channel);
                if (++i != 128) continue;
                i = 0;
                this.channel.flush();
                flushedOnce = true;
            }
            if (i != 0 || !flushedOnce) {
                this.channel.flush();
            }
        }
        finally {
            this.scheduled.set(false);
            if (!this.queue.isEmpty()) {
                this.scheduleFlush();
            }
        }
    }
}

