/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;

public final class TripleHttp2ClientResponseHandler
extends SimpleChannelInboundHandler<Http2StreamFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleHttp2ClientResponseHandler.class);
    private final H2TransportListener transportListener;

    public TripleHttp2ClientResponseHandler(H2TransportListener listener) {
        super(false);
        this.transportListener = listener;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame event = (Http2GoAwayFrame)evt;
            ctx.close();
            LOGGER.debug("Event triggered, event name is: " + event.name() + ", last stream id is: " + event.lastStreamId());
        } else if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headers = (Http2HeadersFrame)msg;
            this.transportListener.onHeader(headers.headers(), headers.isEndStream());
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame data = (Http2DataFrame)msg;
            this.transportListener.onData(data.content(), data.isEndStream());
        } else {
            super.channelRead(ctx, (Object)msg);
        }
    }

    private void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame resetFrame) {
        LOGGER.warn("Triple Client received remote reset errorCode=" + resetFrame.errorCode());
        this.transportListener.cancelByRemote(resetFrame.errorCode());
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.transportListener.cancelByRemote(Http2Error.NO_ERROR.code());
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TriRpcStatus status = TriRpcStatus.INTERNAL.withCause(cause);
        LOGGER.warn("Meet Exception on ClientResponseHandler, status code is: " + status.code, cause);
        this.transportListener.cancelByRemote(Http2Error.INTERNAL_ERROR.code());
        ctx.close();
    }
}

