/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.handler.codec.http2.Http2Headers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;

public abstract class AbstractH2TransportListener
implements H2TransportListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractH2TransportListener.class);

    protected Map<String, Object> headersToMap(Http2Headers trailers) {
        if (trailers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(trailers.size());
        for (Map.Entry header : trailers) {
            String key = ((CharSequence)header.getKey()).toString();
            if (key.endsWith("-bin") && key.length() > "-bin".length()) {
                try {
                    String realKey = key.substring(0, key.length() - "-bin".length());
                    byte[] value = StreamUtils.decodeASCIIByte((CharSequence)header.getValue());
                    attachments.put(realKey, value);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse response attachment key=" + key, (Throwable)e);
                }
                continue;
            }
            attachments.put(key, ((CharSequence)header.getValue()).toString());
        }
        return attachments;
    }

    protected Map<String, String> filterReservedHeaders(Http2Headers trailers) {
        if (trailers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> excludeHeaders = new HashMap<String, String>(trailers.size());
        for (Map.Entry header : trailers) {
            String key = ((CharSequence)header.getKey()).toString();
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key)) {
                excludeHeaders.put(key, ((CharSequence)trailers.getAndRemove((Object)key)).toString());
            }
            if (!TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            excludeHeaders.put(key, ((CharSequence)trailers.getAndRemove((Object)key)).toString());
        }
        return excludeHeaders;
    }
}

