/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;

public class ObserverToClientCallListenerAdapter
implements ClientCall.Listener {
    private final StreamObserver<Object> delegate;
    private ClientCall call;
    private Consumer<ClientCall> onStartConsumer = clientCall -> {};

    public ObserverToClientCallListenerAdapter(StreamObserver<Object> delegate) {
        this.delegate = delegate;
    }

    public void setOnStartConsumer(Consumer<ClientCall> onStartConsumer) {
        this.onStartConsumer = onStartConsumer;
    }

    @Override
    public void onMessage(Object message) {
        this.delegate.onNext(message);
        if (this.call.isAutoRequest()) {
            this.call.request(1);
        }
    }

    @Override
    public void onClose(TriRpcStatus status, Map<String, Object> trailers) {
        if (status.isOk()) {
            this.delegate.onCompleted();
        } else {
            this.delegate.onError((Throwable)status.asException());
        }
    }

    @Override
    public void onStart(ClientCall call) {
        this.call = call;
        if (call.isAutoRequest()) {
            call.request(1);
        }
        this.onStartConsumer.accept(call);
    }
}

