/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ByteBufferBackedChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;

public class Http2ProtocolDetector
implements ProtocolDetector {
    private final ChannelBuffer clientPrefaceString = new ByteBufferBackedChannelBuffer(Http2CodecUtil.connectionPrefaceBuf().nioBuffer());

    public ProtocolDetector.Result detect(ChannelBuffer in) {
        int prefaceLen = this.clientPrefaceString.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals((ChannelBuffer)in, (ChannelBuffer)this.clientPrefaceString, (int)bytesRead)) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        if (bytesRead == prefaceLen) {
            return ProtocolDetector.Result.RECOGNIZED;
        }
        return ProtocolDetector.Result.NEED_MORE_DATA;
    }
}

