/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rmi;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.remoting.support.RemoteInvocation;

public class RmiRemoteInvocation
extends RemoteInvocation {
    private static final long serialVersionUID = 1L;
    private static final String DUBBO_ATTACHMENTS_ATTR_NAME = "dubbo.attachments";

    public RmiRemoteInvocation(MethodInvocation methodInvocation) {
        super(methodInvocation);
        this.addAttribute(DUBBO_ATTACHMENTS_ATTR_NAME, new HashMap(RpcContext.getContext().getObjectAttachments()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        RpcContext context = RpcContext.getContext();
        context.setObjectAttachments((Map)((Object)this.getAttribute(DUBBO_ATTACHMENTS_ATTR_NAME)));
        String generic = (String)((Object)this.getAttribute("generic"));
        if (StringUtils.isNotEmpty((String)generic)) {
            context.setAttachment("generic", generic);
        }
        try {
            Object object = super.invoke(targetObject);
            return object;
        }
        finally {
            context.setObjectAttachments(null);
        }
    }
}

