/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.ParameterTypesComparator;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.factory.RestClientFactory;
import org.apache.dubbo.remoting.http.servlet.BootstrapListener;
import org.apache.dubbo.remoting.http.servlet.ServletManager;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.rest.ReferenceCountedClient;
import org.apache.dubbo.rpc.protocol.rest.RestProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.RestServerFactory;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionConfig;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;
import org.apache.dubbo.rpc.protocol.rest.annotation.metadata.MetadataResolver;
import org.apache.dubbo.rpc.protocol.rest.exception.HttpClientException;
import org.apache.dubbo.rpc.protocol.rest.exception.RemoteServerInternalException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;
import org.jboss.resteasy.util.GetRestful;

public class RestProtocol
extends AbstractProxyProtocol {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_CLIENT = "ok-http";
    private static final String DEFAULT_SERVER = "jetty";
    private final RestServerFactory serverFactory = new RestServerFactory();
    private final ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> clients = new ConcurrentHashMap<String, ReferenceCountedClient<? extends RestClient>>();
    private final RestClientFactory clientFactory;
    private final Set<HttpConnectionPreBuildIntercept> httpConnectionPreBuildIntercepts;

    public RestProtocol(FrameworkModel frameworkModel) {
        super(new Class[]{WebApplicationException.class, ProcessingException.class});
        this.clientFactory = (RestClientFactory)frameworkModel.getExtensionLoader(RestClientFactory.class).getAdaptiveExtension();
        this.httpConnectionPreBuildIntercepts = frameworkModel.getExtensionLoader(HttpConnectionPreBuildIntercept.class).getSupportedExtensionInstances();
    }

    public int getDefaultPort() {
        return 80;
    }

    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        Class<?> implClass = url.getServiceModel().getProxyObject().getClass();
        RestProtocolServer server = (RestProtocolServer)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)this.serverMap, (Object)addr, restServer -> {
            RestProtocolServer s = this.serverFactory.createServer(url.getParameter("server", DEFAULT_SERVER));
            s.setAddress(url.getAddress());
            s.start(url);
            return s;
        });
        String contextPath = this.getContextPath(url);
        if ("servlet".equalsIgnoreCase(url.getParameter("server", DEFAULT_SERVER))) {
            ServletContext servletContext = ServletManager.getInstance().getServletContext(-1234);
            if (servletContext == null) {
                throw new RpcException("No servlet context found. Since you are using server='servlet', make sure that you've configured " + BootstrapListener.class.getName() + " in web.xml");
            }
            String webappPath = servletContext.getContextPath();
            if (StringUtils.isNotEmpty((String)webappPath)) {
                if (!contextPath.startsWith(webappPath = webappPath.substring(1))) {
                    throw new RpcException("Since you are using server='servlet', make sure that the 'contextpath' property starts with the path of external webapp");
                }
                if ((contextPath = contextPath.substring(webappPath.length())).startsWith("/")) {
                    contextPath = contextPath.substring(1);
                }
            }
        }
        Class<Object> resourceDef = GetRestful.getRootResourceClass(implClass) != null ? implClass : type;
        server.deploy(resourceDef, impl, contextPath);
        RestProtocolServer s = server;
        return () -> s.undeploy(resourceDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, final URL url) throws RpcException {
        ReferenceCountedClient refClient = (ReferenceCountedClient)((Object)this.clients.get(url.getAddress()));
        if (refClient == null || refClient.isDestroyed()) {
            ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> concurrentMap = this.clients;
            synchronized (concurrentMap) {
                refClient = (ReferenceCountedClient)((Object)this.clients.get(url.getAddress()));
                if (refClient == null || refClient.isDestroyed()) {
                    refClient = (ReferenceCountedClient)((Object)ConcurrentHashMapUtils.computeIfAbsent(this.clients, (Object)url.getAddress(), _key -> this.createReferenceCountedClient(url, this.clients)));
                }
            }
        }
        refClient.retain();
        final Map<String, Map<ParameterTypesComparator, RestMethodMetadata>> metadataMap = MetadataResolver.resolveConsumerServiceMetadata(type, url);
        final ReferenceCountedClient finalRefClient = refClient;
        AbstractInvoker invoker = new AbstractInvoker<T>(type, url, new String[]{"interface", "group", "token"}){

            protected Result doInvoke(Invocation invocation) {
                try {
                    RestMethodMetadata restMethodMetadata = (RestMethodMetadata)((Map)metadataMap.get(invocation.getMethodName())).get(ParameterTypesComparator.getInstance((Class[])invocation.getParameterTypes()));
                    RequestTemplate requestTemplate = new RequestTemplate(invocation, restMethodMetadata.getRequest().getMethod(), url.getAddress(), RestProtocol.this.getContextPath(url));
                    HttpConnectionCreateContext httpConnectionCreateContext = new HttpConnectionCreateContext();
                    httpConnectionCreateContext.setConnectionConfig(new HttpConnectionConfig());
                    httpConnectionCreateContext.setRequestTemplate(requestTemplate);
                    httpConnectionCreateContext.setRestMethodMetadata(restMethodMetadata);
                    httpConnectionCreateContext.setInvocation(invocation);
                    httpConnectionCreateContext.setUrl(url);
                    for (HttpConnectionPreBuildIntercept intercept : RestProtocol.this.httpConnectionPreBuildIntercepts) {
                        intercept.intercept(httpConnectionCreateContext);
                    }
                    CompletableFuture future = finalRefClient.getClient().send(requestTemplate);
                    CompletableFuture responseFuture = new CompletableFuture();
                    AsyncRpcResult asyncRpcResult = new AsyncRpcResult(responseFuture, invocation);
                    future.whenComplete((r, t) -> {
                        if (t != null) {
                            responseFuture.completeExceptionally((Throwable)t);
                        } else {
                            AppResponse appResponse = new AppResponse();
                            try {
                                int responseCode = r.getResponseCode();
                                MediaType mediaType = MediaType.TEXT_PLAIN;
                                if (400 < responseCode && responseCode < 500) {
                                    throw new HttpClientException(r.getMessage());
                                }
                                if (responseCode >= 500) {
                                    throw new RemoteServerInternalException(r.getMessage());
                                }
                                if (responseCode < 400) {
                                    mediaType = MediaTypeUtil.convertMediaType(r.getContentType());
                                }
                                Object value = HttpMessageCodecManager.httpMessageDecode(r.getBody(), restMethodMetadata.getReflectMethod().getReturnType(), mediaType);
                                appResponse.setValue(value);
                                Map<String, String> headers = r.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
                                appResponse.setAttachments(headers);
                                responseFuture.complete(appResponse);
                            }
                            catch (Exception e2) {
                                responseFuture.completeExceptionally(e2);
                            }
                        }
                    });
                    return asyncRpcResult;
                }
                catch (RpcException e) {
                    if (e.getCode() == 0) {
                        e.setCode(RestProtocol.this.getErrorCode(e.getCause()));
                    }
                    throw e;
                }
            }

            public void destroy() {
                super.destroy();
                RestProtocol.this.invokers.remove((Object)this);
                RestProtocol.this.destroyInternal(url);
            }
        };
        this.invokers.add(invoker);
        return invoker;
    }

    private ReferenceCountedClient<? extends RestClient> createReferenceCountedClient(URL url, ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> clients) throws RpcException {
        RestClient restClient = this.clientFactory.createRestClient(url);
        ReferenceCountedClient<RestClient> refClient = new ReferenceCountedClient<RestClient>(restClient, clients, this.clientFactory, url);
        return refClient;
    }

    protected int getErrorCode(Throwable e) {
        return super.getErrorCode(e);
    }

    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [" + ((Object)((Object)this)).getClass().getSimpleName() + "] ...");
        }
        super.destroy();
        for (Map.Entry entry : this.serverMap.entrySet()) {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing the rest server at " + (String)entry.getKey());
                }
                ((ProtocolServer)entry.getValue()).close();
            }
            catch (Throwable t) {
                this.logger.warn("4-8", "", "", "Error closing rest server", t);
            }
        }
        this.serverMap.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closing rest clients");
        }
        for (ReferenceCountedClient client : this.clients.values()) {
            try {
                client.destroy();
            }
            catch (Throwable t) {
                this.logger.warn("4-7", "", "", "Error closing rest client", t);
            }
        }
        this.clients.clear();
    }

    protected String getContextPath(URL url) {
        String contextPath = url.getPath();
        if (contextPath != null) {
            if (contextPath.equalsIgnoreCase(url.getParameter("interface"))) {
                return "";
            }
            if (contextPath.endsWith(url.getParameter("interface"))) {
                contextPath = contextPath.substring(0, contextPath.lastIndexOf(url.getParameter("interface")));
            }
            return contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath;
        }
        return "";
    }

    protected void destroyInternal(URL url) {
        try {
            ReferenceCountedClient referenceCountedClient = (ReferenceCountedClient)((Object)this.clients.get(url.getAddress()));
            if (referenceCountedClient != null && referenceCountedClient.release()) {
                this.clients.remove(url.getAddress());
            }
        }
        catch (Exception e) {
            this.logger.warn("4-7", "", "", "Failed to close unused resources in rest protocol. interfaceName [" + url.getServiceInterface() + "]", (Throwable)e);
        }
    }
}

