/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.pu;

import java.nio.ByteBuffer;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ByteBufferBackedChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;

public class DubboDetector
implements ProtocolDetector {
    private final ChannelBuffer Preface = new ByteBufferBackedChannelBuffer(ByteBuffer.wrap(new byte[]{-38, -69}));

    public ProtocolDetector.Result detect(ChannelBuffer in) {
        int prefaceLen = this.Preface.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals((ChannelBuffer)in, (ChannelBuffer)this.Preface, (int)bytesRead)) {
            return ProtocolDetector.Result.unrecognized();
        }
        if (bytesRead == prefaceLen) {
            return ProtocolDetector.Result.recognized();
        }
        return ProtocolDetector.Result.needMoreData();
    }
}

