/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CacheableSupplier;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.remoting.transport.ExceedPayloadLimitException;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.PermittedSerializationKeeper;
import org.apache.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Codec,
Decodeable {
    protected static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(DecodeableRpcInvocation.class);
    protected final transient Channel channel;
    protected final byte serializationType;
    protected final transient InputStream inputStream;
    protected final transient Request request;
    protected volatile boolean hasDecoded;
    protected final FrameworkModel frameworkModel;
    protected final transient Supplier<CallbackServiceCodec> callbackServiceCodecFactory;
    private static final boolean CHECK_SERIALIZATION = Boolean.parseBoolean(System.getProperty("serialization.security.check", "true"));

    public DecodeableRpcInvocation(FrameworkModel frameworkModel, Channel channel, Request request, InputStream is, byte id) {
        this.frameworkModel = frameworkModel;
        Assert.notNull((Object)channel, (String)"channel == null");
        Assert.notNull((Object)request, (String)"request == null");
        Assert.notNull((Object)is, (String)"inputStream == null");
        this.channel = channel;
        this.request = request;
        this.inputStream = is;
        this.serializationType = id;
        this.callbackServiceCodecFactory = CacheableSupplier.newSupplier(() -> new CallbackServiceCodec(frameworkModel));
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("4-20", "", "", "Decode rpc invocation failed: " + e.getMessage(), e);
                }
                this.request.setBroken(true);
                this.request.setData((Object)e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object decode(Channel channel, InputStream input) throws IOException {
        int contentLength = input.available();
        this.getAttributes().put("content-length", contentLength);
        ObjectInput in = CodecSupport.getSerialization((Byte)this.serializationType).deserialize(channel.getUrl(), input);
        this.put("serialization_id", this.serializationType);
        String dubboVersion = in.readUTF();
        this.request.setVersion(dubboVersion);
        this.setAttachment("dubbo", dubboVersion);
        String path = in.readUTF();
        this.setAttachment("path", path);
        String version = in.readUTF();
        this.setAttachment("version", version);
        String keyWithoutGroup = BaseServiceMetadata.keyWithoutGroup((String)path, (String)version);
        this.checkPayload(keyWithoutGroup);
        this.setMethodName(in.readUTF());
        String desc = in.readUTF();
        this.setParameterTypesDesc(desc);
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            PermittedSerializationKeeper keeper;
            if (CHECK_SERIALIZATION && !(keeper = (PermittedSerializationKeeper)this.frameworkModel.getBeanFactory().getBean(PermittedSerializationKeeper.class)).checkSerializationPermitted(keyWithoutGroup, Byte.valueOf(this.serializationType))) {
                throw new IOException("Unexpected serialization id:" + this.serializationType + " received from network, please check if the peer send the right id.");
            }
            Object[] args = DubboCodec.EMPTY_OBJECT_ARRAY;
            Class[] pts = DubboCodec.EMPTY_CLASS_ARRAY;
            if (desc.length() > 0) {
                if ((pts = this.drawPts(path, version, desc, pts)) == DubboCodec.EMPTY_CLASS_ARRAY) {
                    if (RpcUtils.isGenericCall((String)desc, (String)this.getMethodName())) {
                        pts = DubboCodec.GENERIC_PTS_ARRAY;
                    } else if (RpcUtils.isEcho((String)desc, (String)this.getMethodName())) {
                        pts = DubboCodec.ECHO_PTS_ARRAY;
                    } else {
                        throw new IllegalArgumentException("Service not found:" + path + ", " + this.getMethodName());
                    }
                }
                args = this.drawArgs(in, pts);
            }
            this.setParameterTypes(pts);
            Map map = in.readAttachments();
            if (CollectionUtils.isNotEmptyMap((Map)map)) {
                this.addObjectAttachments(map);
            }
            this.decodeArgument(channel, pts, args);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString((String)"Read invocation data failed.", (Throwable)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
            if (in instanceof Cleanable) {
                ((Cleanable)in).cleanup();
            }
        }
        return this;
    }

    protected void decodeArgument(Channel channel, Class<?>[] pts, Object[] args) throws IOException {
        CallbackServiceCodec callbackServiceCodec = this.callbackServiceCodecFactory.get();
        for (int i = 0; i < args.length; ++i) {
            args[i] = callbackServiceCodec.decodeInvocationArgument(channel, this, pts, i, args[i]);
        }
        this.setArguments(args);
        String targetServiceName = URL.buildKey((String)this.getAttachment("path"), (String)this.getAttachment("group"), (String)this.getAttachment("version"));
        this.setTargetServiceUniqueName(targetServiceName);
    }

    protected Class<?>[] drawPts(String path, String version, String desc, Class<?>[] pts) {
        MethodDescriptor methodDescriptor;
        FrameworkServiceRepository repository = this.frameworkModel.getServiceRepository();
        List providerModels = repository.lookupExportedServicesWithoutGroup(BaseServiceMetadata.keyWithoutGroup((String)path, (String)version));
        ServiceDescriptor serviceDescriptor = null;
        if (CollectionUtils.isNotEmpty((Collection)providerModels)) {
            ProviderModel providerModel;
            Iterator iterator = providerModels.iterator();
            while (iterator.hasNext() && (serviceDescriptor = (providerModel = (ProviderModel)iterator.next()).getServiceModel()) == null) {
            }
        }
        if (serviceDescriptor == null) {
            for (ApplicationModel applicationModel : this.frameworkModel.getApplicationModels()) {
                ModuleModel moduleModel;
                Iterator iterator = applicationModel.getModuleModels().iterator();
                while (iterator.hasNext() && (serviceDescriptor = (moduleModel = (ModuleModel)iterator.next()).getServiceRepository().lookupService(path)) == null) {
                }
            }
        }
        if (serviceDescriptor != null && (methodDescriptor = serviceDescriptor.getMethod(this.getMethodName(), desc)) != null) {
            pts = methodDescriptor.getParameterClasses();
            this.setReturnTypes(methodDescriptor.getReturnTypes());
            if (CollectionUtils.isNotEmpty((Collection)providerModels)) {
                if (providerModels.size() == 1) {
                    Thread.currentThread().setContextClassLoader(((ProviderModel)providerModels.get(0)).getClassLoader());
                } else {
                    for (ProviderModel providerModel : providerModels) {
                        ClassLoader classLoader = providerModel.getClassLoader();
                        boolean match = true;
                        for (Class<?> pt : pts) {
                            try {
                                if (pt.equals(classLoader.loadClass(pt.getName()))) continue;
                                match = false;
                            }
                            catch (ClassNotFoundException e) {
                                match = false;
                            }
                        }
                        if (!match) continue;
                        Thread.currentThread().setContextClassLoader(classLoader);
                        break;
                    }
                }
            }
        }
        return pts;
    }

    protected Object[] drawArgs(ObjectInput in, Class<?>[] pts) throws IOException, ClassNotFoundException {
        Object[] args = new Object[pts.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = in.readObject(pts[i]);
        }
        return args;
    }

    private void checkPayload(String serviceKey) throws IOException {
        String payloadStr;
        ProviderModel providerModel = this.frameworkModel.getServiceRepository().lookupExportedServiceWithoutGroup(serviceKey);
        if (providerModel != null && (payloadStr = (String)providerModel.getServiceMetadata().getAttachments().get("payload")) != null) {
            int payload = Integer.parseInt(payloadStr);
            if (payload <= 0) {
                return;
            }
            if (this.request.getPayload() > payload) {
                ExceedPayloadLimitException e = new ExceedPayloadLimitException("Data length too large: " + this.request.getPayload() + ", max payload: " + payload + ", channel: " + this.channel);
                log.error("6-10", "", "", e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    protected void fillInvoker(DubboProtocol dubboProtocol) throws RemotingException {
        this.setInvoker(dubboProtocol.getInvoker(this.channel, (Invocation)this));
    }
}

