/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeClient;
import org.apache.dubbo.remoting.transport.ClientDelegate;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.support.RpcUtils;

class ChannelWrappedInvoker<T>
extends AbstractInvoker<T> {
    private final Channel channel;
    private final String serviceKey;
    private final ExchangeClient currentClient;

    ChannelWrappedInvoker(Class<T> serviceType, Channel channel, URL url, String serviceKey) {
        super(serviceType, url, new String[]{"group", "token"});
        this.channel = channel;
        this.serviceKey = serviceKey;
        this.currentClient = new HeaderExchangeClient((Client)new ChannelWrapper(this.channel), false);
    }

    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        inv.setAttachment("path", this.getInterface().getName());
        inv.setAttachment("callback.service.instid", this.serviceKey);
        Integer payload = (Integer)this.getUrl().getParameter("payload", Integer.class);
        Request request = new Request();
        if (payload != null) {
            request.setPayload(payload.intValue());
        }
        request.setData((Object)inv);
        request.setVersion(Version.getProtocolVersion());
        try {
            if (RpcUtils.isOneway((URL)this.getUrl(), (Invocation)inv)) {
                this.currentClient.send((Object)request, this.getUrl().getMethodParameter(RpcUtils.getMethodName((Invocation)invocation), "sent", false));
                return AsyncRpcResult.newDefaultAsyncResult((Invocation)invocation);
            }
            CompletionStage appResponseFuture = this.currentClient.request((Object)request).thenApply(AppResponse.class::cast);
            return new AsyncRpcResult((CompletableFuture)appResponseFuture, (Invocation)inv);
        }
        catch (RpcException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw new RpcException(2, e.getMessage(), (Throwable)e);
        }
        catch (RemotingException e) {
            throw new RpcException(1, e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void destroy() {
    }

    public static class ChannelWrapper
    extends ClientDelegate {
        private final Channel channel;
        private final URL url;

        ChannelWrapper(Channel channel) {
            this.channel = channel;
            this.url = channel.getUrl().addParameter("codec", "dubbo");
        }

        public URL getUrl() {
            return this.url;
        }

        public ChannelHandler getChannelHandler() {
            return this.channel.getChannelHandler();
        }

        public InetSocketAddress getLocalAddress() {
            return this.channel.getLocalAddress();
        }

        public void close() {
            this.channel.close();
        }

        public boolean isClosed() {
            return this.channel == null || this.channel.isClosed();
        }

        public void reset(URL url) {
            throw new RpcException("ChannelInvoker can not reset.");
        }

        public InetSocketAddress getRemoteAddress() {
            return this.channel.getRemoteAddress();
        }

        public boolean isConnected() {
            return this.channel != null && this.channel.isConnected();
        }

        public boolean hasAttribute(String key) {
            return this.channel.hasAttribute(key);
        }

        public Object getAttribute(String key) {
            return this.channel.getAttribute(key);
        }

        public void setAttribute(String key, Object value) {
            this.channel.setAttribute(key, value);
        }

        public void removeAttribute(String key) {
            this.channel.removeAttribute(key);
        }

        public void reconnect() throws RemotingException {
        }

        public void send(Object message) throws RemotingException {
            this.channel.send(message);
        }

        public void send(Object message, boolean sent) throws RemotingException {
            this.channel.send(message, sent);
        }
    }
}

