/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceModel;

@Activate(order=200)
public class ProtocolSecurityWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolSecurityWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        ServiceModel serviceModel = invoker.getUrl().getServiceModel();
        ScopeModel scopeModel = invoker.getUrl().getScopeModel();
        Optional.ofNullable(serviceModel).map(ServiceModel::getServiceModel).map(ServiceDescriptor::getServiceInterfaceClass).ifPresent(interfaceClass -> {
            SerializeSecurityManager serializeSecurityManager = (SerializeSecurityManager)ScopeModelUtil.getFrameworkModel((ScopeModel)scopeModel).getBeanFactory().getBean(SerializeSecurityManager.class);
            serializeSecurityManager.registerInterface(interfaceClass);
        });
        return this.protocol.export(invoker);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        ServiceModel serviceModel = url.getServiceModel();
        ScopeModel scopeModel = url.getScopeModel();
        SerializeSecurityManager serializeSecurityManager = (SerializeSecurityManager)ScopeModelUtil.getFrameworkModel((ScopeModel)scopeModel).getBeanFactory().getBean(SerializeSecurityManager.class);
        Optional.ofNullable(serviceModel).map(ServiceModel::getServiceModel).map(ServiceDescriptor::getServiceInterfaceClass).ifPresent(arg_0 -> ((SerializeSecurityManager)serializeSecurityManager).registerInterface(arg_0));
        serializeSecurityManager.registerInterface(type);
        return this.protocol.refer(type, url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

