/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PenetrateAttachmentSelector;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"}, order=-2147483648)
public class ContextFilter
implements Filter,
BaseFilter.Listener {
    private Set<PenetrateAttachmentSelector> supportedSelectors;
    private static final Set<String> UNLOADING_KEYS = new HashSet<String>(16);

    public ContextFilter(ApplicationModel applicationModel) {
        ExtensionLoader selectorExtensionLoader = applicationModel.getExtensionLoader(PenetrateAttachmentSelector.class);
        this.supportedSelectors = selectorExtensionLoader.getSupportedExtensionInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String remoteApplication;
        Map<String, Object> attachments = invocation.getObjectAttachments();
        if (attachments != null) {
            HashMap<String, Object> newAttach = new HashMap<String, Object>(attachments.size());
            for (Map.Entry<String, Object> entry : attachments.entrySet()) {
                String key = entry.getKey();
                if (UNLOADING_KEYS.contains(key)) continue;
                newAttach.put(key, entry.getValue());
            }
            attachments = newAttach;
        }
        ((RpcServiceContext)RpcContext.getServiceContext().setInvoker((Invoker)invoker)).setInvocation(invocation);
        RpcContextAttachment context = RpcContext.getServerAttachment();
        if (context.getLocalAddress() == null) {
            context.setLocalAddress(invoker.getUrl().getHost(), invoker.getUrl().getPort());
        }
        if (StringUtils.isNotEmpty((String)(remoteApplication = invocation.getAttachment("remote.application")))) {
            RpcContext.getServiceContext().setRemoteApplicationName(remoteApplication);
        } else {
            RpcContext.getServiceContext().setRemoteApplicationName(((RpcContext)context).getAttachment("remote.application"));
        }
        long timeout = RpcUtils.getTimeout(invocation, -1L);
        if (timeout != -1L) {
            RpcContext.getServerAttachment().setObjectAttachment("timeout-countdown", TimeoutCountDown.newCountDown(timeout, TimeUnit.MILLISECONDS));
        }
        if (CollectionUtils.isNotEmptyMap(attachments)) {
            if (((RpcContext)context).getObjectAttachments().size() > 0) {
                ((RpcContext)context).getObjectAttachments().putAll(attachments);
            } else {
                ((RpcContext)context).setObjectAttachments(attachments);
            }
        }
        if (invocation instanceof RpcInvocation) {
            RpcInvocation rpcInvocation = (RpcInvocation)invocation;
            rpcInvocation.setInvoker(invoker);
        }
        try {
            context.clearAfterEachInvoke(false);
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            context.clearAfterEachInvoke(true);
            if (((RpcContext)context).isAsyncStarted()) {
                this.removeContext();
            }
        }
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        if (CollectionUtils.isNotEmpty(this.supportedSelectors)) {
            for (PenetrateAttachmentSelector supportedSelector : this.supportedSelectors) {
                Map<String, Object> selected = supportedSelector.selectReverse(invocation, RpcContext.getClientResponseContext(), RpcContext.getServerResponseContext());
                if (!CollectionUtils.isNotEmptyMap(selected)) continue;
                appResponse.addObjectAttachments(selected);
            }
        } else {
            appResponse.addObjectAttachments(RpcContext.getClientResponseContext().getObjectAttachments());
        }
        appResponse.addObjectAttachments(RpcContext.getServerResponseContext().getObjectAttachments());
        this.removeContext();
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.removeContext();
    }

    private void removeContext() {
        RpcContext.removeServerAttachment();
        RpcContext.removeClientAttachment();
        RpcContext.removeServiceContext();
        RpcContext.removeClientResponseContext();
        RpcContext.removeServerResponseContext();
    }

    static {
        UNLOADING_KEYS.add("path");
        UNLOADING_KEYS.add("interface");
        UNLOADING_KEYS.add("group");
        UNLOADING_KEYS.add("version");
        UNLOADING_KEYS.add("dubbo");
        UNLOADING_KEYS.add("token");
        UNLOADING_KEYS.add("timeout");
        UNLOADING_KEYS.add("_TO");
        UNLOADING_KEYS.add("async");
        UNLOADING_KEYS.add("dubbo.tag");
        UNLOADING_KEYS.add("dubbo.force.tag");
    }
}

