/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.listener;

import java.util.List;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.InvokerListener;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class ListenerInvokerWrapper<T>
implements Invoker<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ListenerInvokerWrapper.class);
    private final Invoker<T> invoker;
    private final List<InvokerListener> listeners;

    public ListenerInvokerWrapper(Invoker<T> invoker, List<InvokerListener> listeners) {
        if (invoker == null) {
            throw new IllegalArgumentException("invoker == null");
        }
        this.invoker = invoker;
        this.listeners = listeners;
        this.listenerEvent(listener -> listener.referred(invoker));
    }

    @Override
    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    public URL getUrl() {
        return this.invoker.getUrl();
    }

    public boolean isAvailable() {
        return this.invoker.isAvailable();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        return this.invoker.invoke(invocation);
    }

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? " " : this.getUrl().toString());
    }

    public void destroy() {
        try {
            this.invoker.destroy();
        }
        finally {
            this.listenerEvent(listener -> listener.destroyed(this.invoker));
        }
    }

    public Invoker<T> getInvoker() {
        return this.invoker;
    }

    public List<InvokerListener> getListeners() {
        return this.listeners;
    }

    private void listenerEvent(Consumer<InvokerListener> consumer) {
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            RuntimeException exception = null;
            for (InvokerListener listener : this.listeners) {
                if (listener == null) continue;
                try {
                    consumer.accept(listener);
                }
                catch (RuntimeException t) {
                    logger.error(t.getMessage(), (Throwable)t);
                    exception = t;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

