/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.stub;

import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.proxy.InvocationUtil;

public class StubInvocationUtil {
    public static <T, R> R unaryCall(Invoker<?> invoker, MethodDescriptor methodDescriptor, T request) {
        return (R)StubInvocationUtil.call(invoker, methodDescriptor, new Object[]{request});
    }

    public static <T, R> void unaryCall(Invoker<?> invoker, MethodDescriptor method, T request, StreamObserver<R> responseObserver) {
        try {
            R res = StubInvocationUtil.unaryCall(invoker, method, request);
            responseObserver.onNext(res);
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public static <T, R> StreamObserver<T> biOrClientStreamCall(Invoker<?> invoker, MethodDescriptor method, StreamObserver<R> responseObserver) {
        return (StreamObserver)StubInvocationUtil.call(invoker, method, new Object[]{responseObserver});
    }

    public static <T, R> void serverStreamCall(Invoker<?> invoker, MethodDescriptor method, T request, StreamObserver<R> responseObserver) {
        StubInvocationUtil.call(invoker, method, new Object[]{request, responseObserver});
    }

    private static Object call(Invoker<?> invoker, MethodDescriptor methodDescriptor, Object[] arguments) {
        RpcInvocation rpcInvocation = new RpcInvocation(invoker.getUrl().getServiceModel(), methodDescriptor.getMethodName(), invoker.getInterface().getName(), invoker.getUrl().getProtocolServiceKey(), methodDescriptor.getParameterClasses(), arguments);
        try {
            return InvocationUtil.invoke(invoker, rpcInvocation);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw TriRpcStatus.INTERNAL.withCause(e).asException();
        }
    }
}

