/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.support.RpcUtils;

public class RpcInvocation
implements Invocation,
Serializable {
    private static final long serialVersionUID = -4355285085441097045L;
    private String targetServiceUniqueName;
    private String methodName;
    private String serviceName;
    private transient Class<?>[] parameterTypes;
    private String parameterTypesDesc;
    private String[] compatibleParamSignatures;
    private Object[] arguments;
    private Map<String, String> attachments;
    private Map<Object, Object> attributes = new HashMap<Object, Object>();
    private transient Invoker<?> invoker;
    private transient Class<?> returnType;
    private transient Type[] returnTypes;
    private transient InvokeMode invokeMode;

    public RpcInvocation() {
    }

    public RpcInvocation(Invocation invocation, Invoker<?> invoker) {
        this(invocation.getMethodName(), invocation.getServiceName(), invocation.getParameterTypes(), invocation.getArguments(), new HashMap<String, String>(invocation.getAttachments()), invocation.getInvoker(), invocation.getAttributes());
        if (invoker != null) {
            URL url = invoker.getUrl();
            this.setAttachment("path", url.getPath());
            if (url.hasParameter("interface")) {
                this.setAttachment("interface", url.getParameter("interface"));
            }
            if (url.hasParameter("group")) {
                this.setAttachment("group", url.getParameter("group"));
            }
            if (url.hasParameter("version")) {
                this.setAttachment("version", url.getParameter("version", "0.0.0"));
            }
            if (url.hasParameter("timeout")) {
                this.setAttachment("timeout", url.getParameter("timeout"));
            }
            if (url.hasParameter("token")) {
                this.setAttachment("token", url.getParameter("token"));
            }
            if (url.hasParameter("application")) {
                this.setAttachment("application", url.getParameter("application"));
            }
        }
        this.targetServiceUniqueName = invocation.getTargetServiceUniqueName();
    }

    public RpcInvocation(Invocation invocation) {
        this(invocation.getMethodName(), invocation.getServiceName(), invocation.getParameterTypes(), invocation.getArguments(), invocation.getAttachments(), invocation.getInvoker(), invocation.getAttributes());
        this.targetServiceUniqueName = invocation.getTargetServiceUniqueName();
    }

    public RpcInvocation(Method method, String serviceName, Object[] arguments) {
        this(method, serviceName, arguments, null, null);
    }

    public RpcInvocation(Method method, String serviceName, Object[] arguments, Map<String, String> attachment, Map<Object, Object> attributes) {
        this(method.getName(), serviceName, method.getParameterTypes(), arguments, attachment, null, attributes);
        this.returnType = method.getReturnType();
    }

    public RpcInvocation(String methodName, String serviceName, Class<?>[] parameterTypes, Object[] arguments) {
        this(methodName, serviceName, parameterTypes, arguments, null, null, null);
    }

    public RpcInvocation(String methodName, String serviceName, Class<?>[] parameterTypes, Object[] arguments, Map<String, String> attachments) {
        this(methodName, serviceName, parameterTypes, arguments, attachments, null, null);
    }

    public RpcInvocation(String methodName, String serviceName, Class<?>[] parameterTypes, Object[] arguments, Map<String, String> attachments, Invoker<?> invoker, Map<Object, Object> attributes) {
        this.methodName = methodName;
        this.serviceName = serviceName;
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
        this.arguments = arguments == null ? new Object[]{} : arguments;
        this.attachments = attachments == null ? new HashMap() : attachments;
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.invoker = invoker;
        this.initParameterDesc();
    }

    private void initParameterDesc() {
        MethodDescriptor methodDescriptor;
        ServiceDescriptor serviceDescriptor;
        ServiceRepository repository = ApplicationModel.getServiceRepository();
        if (StringUtils.isNotEmpty((String)this.serviceName) && (serviceDescriptor = repository.lookupService(this.serviceName)) != null && (methodDescriptor = serviceDescriptor.getMethod(this.methodName, (Class[])this.parameterTypes)) != null) {
            this.parameterTypesDesc = methodDescriptor.getParamDesc();
            this.compatibleParamSignatures = methodDescriptor.getCompatibleParamSignatures();
            this.returnTypes = methodDescriptor.getReturnTypes();
        }
        if (this.parameterTypesDesc == null) {
            this.parameterTypesDesc = ReflectUtils.getDesc((Class[])this.getParameterTypes());
            this.compatibleParamSignatures = (String[])Stream.of(this.parameterTypes).map(Class::getName).toArray(String[]::new);
            this.returnTypes = RpcUtils.getReturnTypes(this);
        }
    }

    @Override
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getTargetServiceUniqueName() {
        return this.targetServiceUniqueName;
    }

    public void setTargetServiceUniqueName(String targetServiceUniqueName) {
        this.targetServiceUniqueName = targetServiceUniqueName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
    }

    public String getParameterTypesDesc() {
        return this.parameterTypesDesc;
    }

    public void setParameterTypesDesc(String parameterTypesDesc) {
        this.parameterTypesDesc = parameterTypesDesc;
    }

    @Override
    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public void setCompatibleParamSignatures(String[] compatibleParamSignatures) {
        this.compatibleParamSignatures = compatibleParamSignatures;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments == null ? new Object[]{} : arguments;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments == null ? new HashMap() : attachments;
    }

    @Override
    public void setAttachment(String key, String value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, String>();
        }
        this.attachments.put(key, value);
    }

    @Override
    public void setAttachmentIfAbsent(String key, String value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, String>();
        }
        if (!this.attachments.containsKey(key)) {
            this.attachments.put(key, value);
        }
    }

    public void addAttachments(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new HashMap<String, String>();
        }
        this.attachments.putAll(attachments);
    }

    public void addAttachmentsIfAbsent(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.get(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        if (this.attachments == null) {
            return defaultValue;
        }
        String value = this.attachments.get(key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public void setReturnTypes(Type[] returnTypes) {
        this.returnTypes = returnTypes;
    }

    public InvokeMode getInvokeMode() {
        return this.invokeMode;
    }

    public void setInvokeMode(InvokeMode invokeMode) {
        this.invokeMode = invokeMode;
    }

    public String toString() {
        return "RpcInvocation [methodName=" + this.methodName + ", parameterTypes=" + Arrays.toString(this.parameterTypes) + ", arguments=" + Arrays.toString(this.arguments) + ", attachments=" + this.attachments + "]";
    }
}

