/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcResult;
import org.apache.dubbo.rpc.support.RpcUtils;

public abstract class AbstractInvoker<T>
implements Invoker<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> type;
    private final URL url;
    private final Map<String, String> attachment;
    private volatile boolean available = true;
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public AbstractInvoker(Class<T> type, URL url) {
        this(type, url, (Map<String, String>)null);
    }

    public AbstractInvoker(Class<T> type, URL url, String[] keys) {
        this(type, url, AbstractInvoker.convertAttachment(url, keys));
    }

    public AbstractInvoker(Class<T> type, URL url, Map<String, String> attachment) {
        if (type == null) {
            throw new IllegalArgumentException("service type == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("service url == null");
        }
        this.type = type;
        this.url = url;
        this.attachment = attachment == null ? null : Collections.unmodifiableMap(attachment);
    }

    private static Map<String, String> convertAttachment(URL url, String[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        HashMap<String, String> attachment = new HashMap<String, String>();
        for (String key : keys) {
            String value = url.getParameter(key);
            if (value == null || value.length() <= 0) continue;
            attachment.put(key, value);
        }
        return attachment;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return this.available;
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.setAvailable(false);
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? "" : this.getUrl().toString());
    }

    @Override
    public Result invoke(Invocation inv) throws RpcException {
        Map<String, String> contextAttachments;
        if (this.destroyed.get()) {
            this.logger.warn("Invoker for service " + this + " on consumer " + NetUtils.getLocalHost() + " is destroyed, , dubbo version is " + Version.getVersion() + ", this invoker should not be used any longer");
        }
        RpcInvocation invocation = (RpcInvocation)inv;
        invocation.setInvoker(this);
        if (this.attachment != null && this.attachment.size() > 0) {
            invocation.addAttachmentsIfAbsent(this.attachment);
        }
        if ((contextAttachments = RpcContext.getContext().getAttachments()) != null && contextAttachments.size() != 0) {
            invocation.addAttachments(contextAttachments);
        }
        if (this.getUrl().getMethodParameter(invocation.getMethodName(), "async", false)) {
            invocation.setAttachment("async", Boolean.TRUE.toString());
        }
        RpcUtils.attachInvocationIdIfAsync(this.getUrl(), invocation);
        try {
            return this.doInvoke(invocation);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te == null) {
                return new RpcResult(e);
            }
            if (te instanceof RpcException) {
                ((RpcException)te).setCode(3);
            }
            return new RpcResult(te);
        }
        catch (RpcException e) {
            if (e.isBiz()) {
                return new RpcResult(e);
            }
            throw e;
        }
        catch (Throwable e) {
            return new RpcResult(e);
        }
    }

    protected abstract Result doInvoke(Invocation var1) throws Throwable;
}

