/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.AbstractResult;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcResult;

public class AsyncRpcResult
extends AbstractResult {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRpcResult.class);
    private RpcContext storedContext;
    private RpcContext storedServerContext;
    protected CompletableFuture<Object> valueFuture;
    protected CompletableFuture<Result> resultFuture;
    private RpcContext tmpContext;
    private RpcContext tmpServerContext;
    private Function<Result, Result> beforeContext = result -> {
        this.tmpContext = RpcContext.getContext();
        this.tmpServerContext = RpcContext.getServerContext();
        RpcContext.restoreContext(this.storedContext);
        RpcContext.restoreServerContext(this.storedServerContext);
        return result;
    };
    private Function<Result, Result> afterContext = result -> {
        RpcContext.restoreContext(this.tmpContext);
        RpcContext.restoreServerContext(this.tmpServerContext);
        return result;
    };

    public AsyncRpcResult(CompletableFuture<Object> future) {
        this(future, true);
    }

    public AsyncRpcResult(CompletableFuture<Object> future, boolean registerCallback) {
        this(future, new CompletableFuture<Result>(), registerCallback);
    }

    public AsyncRpcResult(CompletableFuture<Object> future, CompletableFuture<Result> rFuture, boolean registerCallback) {
        if (rFuture == null) {
            throw new IllegalArgumentException();
        }
        this.resultFuture = rFuture;
        if (registerCallback) {
            future.whenComplete((v, t) -> {
                RpcResult rpcResult = t != null ? (t instanceof CompletionException ? new RpcResult(t.getCause()) : new RpcResult((Throwable)t)) : new RpcResult(v);
                rFuture.complete(rpcResult);
            });
        }
        this.valueFuture = future;
        this.storedContext = RpcContext.getContext().copyOf();
        this.storedServerContext = RpcContext.getServerContext().copyOf();
    }

    @Override
    public Object getValue() {
        return this.getRpcResult().getValue();
    }

    @Override
    public Throwable getException() {
        return this.getRpcResult().getException();
    }

    @Override
    public boolean hasException() {
        return this.getRpcResult().hasException();
    }

    @Override
    public Object getResult() {
        return this.getRpcResult().getResult();
    }

    public CompletableFuture getValueFuture() {
        return this.valueFuture;
    }

    public CompletableFuture<Result> getResultFuture() {
        return this.resultFuture;
    }

    public void setResultFuture(CompletableFuture<Result> resultFuture) {
        this.resultFuture = resultFuture;
    }

    public Result getRpcResult() {
        try {
            if (this.resultFuture.isDone()) {
                return this.resultFuture.get();
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to fetch the underlying result from AsyncRpcResult.", (Throwable)e);
        }
        return new RpcResult();
    }

    @Override
    public Object recreate() throws Throwable {
        return this.valueFuture;
    }

    public void thenApplyWithContext(Function<Result, Result> fn) {
        this.resultFuture = this.resultFuture.thenApply(fn.compose(this.beforeContext).andThen(this.afterContext));
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.getRpcResult().getAttachments();
    }

    @Override
    public void setAttachments(Map<String, String> map) {
        this.getRpcResult().setAttachments(map);
    }

    @Override
    public void addAttachments(Map<String, String> map) {
        this.getRpcResult().addAttachments(map);
    }

    @Override
    public String getAttachment(String key) {
        return this.getRpcResult().getAttachment(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        return this.getRpcResult().getAttachment(key, defaultValue);
    }

    @Override
    public void setAttachment(String key, String value) {
        this.getRpcResult().setAttachment(key, value);
    }
}

