/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.AsyncContext;
import org.apache.dubbo.rpc.RpcContext;

public class AsyncContextImpl
implements AsyncContext {
    private static final Logger logger = LoggerFactory.getLogger(AsyncContextImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private CompletableFuture<Object> future;
    private RpcContext storedContext = RpcContext.getContext();
    private RpcContext storedServerContext = RpcContext.getServerContext();

    @Override
    public void write(Object value) {
        if (this.isAsyncStarted() && this.stop()) {
            if (value instanceof Throwable) {
                Throwable bizExe = (Throwable)value;
                this.future.completeExceptionally(bizExe);
            } else {
                this.future.complete(value);
            }
        } else {
            throw new IllegalStateException("The async response has probably been wrote back by another thread, or the asyncContext has been closed.");
        }
    }

    @Override
    public boolean isAsyncStarted() {
        return this.started.get();
    }

    @Override
    public boolean stop() {
        return this.stopped.compareAndSet(false, true);
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.future = new CompletableFuture();
        }
    }

    @Override
    public void signalContextSwitch() {
        RpcContext.restoreContext(this.storedContext);
        RpcContext.restoreServerContext(this.storedServerContext);
    }

    public CompletableFuture<Object> getInternalFuture() {
        return this.future;
    }
}

