/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.pu.DefaultCodec;
import org.apache.dubbo.remoting.transport.codec.CodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;

public class NettyConfigOperator
implements ChannelOperator {
    private final Channel channel;
    private ChannelHandler handler;
    private ProtocolDetector.Result detectResult;

    public NettyConfigOperator(NettyChannel channel, ChannelHandler handler) {
        this.channel = channel;
        this.handler = handler;
    }

    public void configChannelHandler(List<ChannelHandler> handlerList) {
        Object codec2;
        URL url = this.channel.getUrl();
        String codecName = url.getParameter("codec");
        if (StringUtils.isEmpty((String)codecName)) {
            codecName = url.getProtocol();
        }
        if (!((codec2 = url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).hasExtension(codecName) ? (Codec2)url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).getExtension(codecName) : (url.getOrDefaultFrameworkModel().getExtensionLoader(Codec.class).hasExtension(codecName) ? new CodecAdapter((Codec)url.getOrDefaultFrameworkModel().getExtensionLoader(Codec.class).getExtension(codecName)) : (Codec2)url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).getExtension("default"))) instanceof DefaultCodec)) {
            ((NettyChannel)this.channel).setCodec((Codec2)codec2);
            NettyCodecAdapter codec = new NettyCodecAdapter((Codec2)codec2, this.channel.getUrl(), this.handler);
            ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{codec.getDecoder()}).addLast(new io.netty.channel.ChannelHandler[]{codec.getEncoder()});
        }
        for (ChannelHandler handler : handlerList) {
            if (!(handler instanceof ChannelHandlerPretender)) continue;
            Object realHandler = ((ChannelHandlerPretender)handler).getRealHandler();
            this.addRealHandler(realHandler);
        }
        if (!this.isClientSide(this.channel)) {
            NettyServerHandler sh = new NettyServerHandler(this.channel.getUrl(), this.handler);
            ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{sh});
        }
    }

    private void addRealHandler(Object realHandler) {
        if (realHandler instanceof Collection) {
            Collection realHandlers = (Collection)realHandler;
            for (Object handler : realHandlers) {
                this.addChannelHandler(handler);
            }
        } else {
            this.addChannelHandler(realHandler);
        }
    }

    private void addChannelHandler(Object channelHandler) {
        if (!(channelHandler instanceof io.netty.channel.ChannelHandler)) {
            return;
        }
        ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{(io.netty.channel.ChannelHandler)channelHandler});
    }

    public void setDetectResult(ProtocolDetector.Result detectResult) {
        this.detectResult = detectResult;
    }

    public ProtocolDetector.Result detectResult() {
        return this.detectResult;
    }

    private boolean isClientSide(Channel channel) {
        return channel.getUrl().getSide("").equalsIgnoreCase("consumer");
    }
}

