/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyBackedChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;

public class NettyPortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyPortUnificationServerHandler.class);
    private final SslContext sslCtx;
    private final URL url;
    private final ChannelHandler handler;
    private final boolean detectSsl;
    private final List<WireProtocol> protocols;
    private final Map<String, Channel> dubboChannels;
    private final Map<String, URL> urlMapper;
    private final Map<String, ChannelHandler> handlerMapper;

    public NettyPortUnificationServerHandler(URL url, SslContext sslCtx, boolean detectSsl, List<WireProtocol> protocols, ChannelHandler handler, Map<String, Channel> dubboChannels, Map<String, URL> urlMapper, Map<String, ChannelHandler> handlerMapper) {
        this.url = url;
        this.sslCtx = sslCtx;
        this.protocols = protocols;
        this.detectSsl = detectSsl;
        this.handler = handler;
        this.dubboChannels = dubboChannels;
        this.urlMapper = urlMapper;
        this.handlerMapper = handlerMapper;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("99-0", "unknown error in remoting module", "", "Unexpected exception from downstream before protocol detected.", cause);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        if (channel != null) {
            this.dubboChannels.put(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())), (Channel)channel);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        if (in.readableBytes() < 2) {
            return;
        }
        if (this.isSsl(in)) {
            this.enableSsl(ctx);
        } else {
            block5: for (WireProtocol protocol : this.protocols) {
                in.markReaderIndex();
                NettyBackedChannelBuffer buf = new NettyBackedChannelBuffer(in);
                ProtocolDetector.Result result = protocol.detector().detect((ChannelBuffer)buf);
                in.resetReaderIndex();
                switch (result) {
                    case UNRECOGNIZED: {
                        continue block5;
                    }
                    case RECOGNIZED: {
                        String protocolName = this.url.getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getExtensionName((Object)protocol);
                        ChannelHandler localHandler = this.handlerMapper.getOrDefault(protocolName, this.handler);
                        URL localURL = this.urlMapper.getOrDefault(protocolName, this.url);
                        channel.setUrl(localURL);
                        NettyConfigOperator operator = new NettyConfigOperator(channel, localHandler);
                        protocol.configServerProtocolHandler(this.url, (ChannelOperator)operator);
                        ctx.pipeline().remove((io.netty.channel.ChannelHandler)this);
                    }
                    case NEED_MORE_DATA: {
                        return;
                    }
                }
                return;
            }
            byte[] preface = new byte[in.readableBytes()];
            in.readBytes(preface);
            Set supported = this.url.getApplicationModel().getExtensionLoader(WireProtocol.class).getSupportedExtensions();
            LOGGER.error("99-0", "unknown error in remoting module", "", String.format("Can not recognize protocol from downstream=%s . preface=%s protocols=%s", ctx.channel().remoteAddress(), Bytes.bytes2hex((byte[])preface), supported));
            in.clear();
            ctx.close();
        }
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        if (this.sslCtx != null) {
            p.addLast("ssl", (io.netty.channel.ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
        }
        p.addLast("unificationA", (io.netty.channel.ChannelHandler)new NettyPortUnificationServerHandler(this.url, this.sslCtx, false, this.protocols, this.handler, this.dubboChannels, this.urlMapper, this.handlerMapper));
        p.remove((io.netty.channel.ChannelHandler)this);
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl && buf.readableBytes() >= 5) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }
}

