/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import io.netty.handler.codec.DateFormatter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.message.DefaultHttpResult;

public class DefaultHttpResponse
implements HttpResponse {
    private HttpHeaders headers;
    private int status;
    private String contentType;
    private String charset;
    private Object body;
    private OutputStream outputStream;
    private volatile boolean committed;

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        if (this.committed) {
            return;
        }
        this.status = status;
    }

    @Override
    public String header(CharSequence name) {
        return this.headers == null ? null : this.headers.getFirst(name);
    }

    @Override
    public Date dateHeader(CharSequence name) {
        String value = this.header(name);
        return StringUtils.isEmpty((String)value) ? null : DateFormatter.parseHttpDate((CharSequence)value);
    }

    @Override
    public List<String> headerValues(CharSequence name) {
        return this.headers == null ? Collections.emptyList() : this.headers.get(name);
    }

    @Override
    public boolean hasHeader(CharSequence name) {
        return this.headers != null && this.headers.containsKey(name);
    }

    @Override
    public Collection<String> headerNames() {
        return this.headers == null ? Collections.emptyList() : this.headers.names();
    }

    @Override
    public HttpHeaders headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.create();
        }
        return this.headers;
    }

    @Override
    public void addHeader(CharSequence name, String value) {
        if (this.committed) {
            return;
        }
        this.headers().add(name, value);
    }

    @Override
    public void addHeader(CharSequence name, Date value) {
        this.addHeader(name, DateFormatter.format((Date)value));
    }

    @Override
    public void setHeader(CharSequence name, String value) {
        if (this.committed) {
            return;
        }
        this.headers().set(name, value);
    }

    @Override
    public void setHeader(CharSequence name, Date value) {
        this.setHeader(name, DateFormatter.format((Date)value));
    }

    @Override
    public void setHeader(CharSequence name, List<String> values) {
        if (this.committed) {
            return;
        }
        this.headers().set(name, values);
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.addHeader(HttpHeaderNames.SET_COOKIE.getKey(), HttpUtils.encodeCookie(cookie));
    }

    @Override
    public String contentType() {
        String contentType = this.contentType;
        if (contentType == null) {
            contentType = this.header(HttpHeaderNames.CONTENT_TYPE.getKey());
            this.contentType = contentType = contentType == null ? "" : contentType.trim();
        }
        return contentType.isEmpty() ? null : contentType;
    }

    @Override
    public void setContentType(String contentType) {
        if (this.committed) {
            return;
        }
        this.contentType = contentType;
        this.charset = null;
    }

    @Override
    public String mediaType() {
        String contentType = this.contentType();
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        return index == -1 ? contentType : contentType.substring(0, index);
    }

    @Override
    public String charset() {
        String charset = this.charset;
        if (charset == null) {
            int index;
            String contentType = this.contentType();
            charset = contentType == null ? "" : ((index = contentType.lastIndexOf("charset=")) == -1 ? "" : contentType.substring(index + 8).trim());
            this.charset = charset;
        }
        return charset.isEmpty() ? null : charset;
    }

    @Override
    public void setCharset(String charset) {
        if (this.committed) {
            return;
        }
        String contentType = this.contentType();
        if (contentType != null) {
            this.contentType = contentType + "; " + "charset=" + charset;
        }
        this.charset = charset;
    }

    @Override
    public String locale() {
        return this.header(HttpHeaderNames.CONTENT_LANGUAGE.getKey());
    }

    @Override
    public void setLocale(String locale) {
        if (this.committed) {
            return;
        }
        this.setHeader(HttpHeaderNames.CONTENT_LANGUAGE.getKey(), locale);
    }

    @Override
    public Object body() {
        return this.body;
    }

    @Override
    public void setBody(Object body) {
        if (this.committed) {
            return;
        }
        this.body = body;
    }

    @Override
    public OutputStream outputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream(1024);
        }
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        if (this.committed) {
            return;
        }
        this.outputStream = os;
    }

    @Override
    public void sendRedirect(String location) {
        this.check();
        this.setStatus(HttpStatus.FOUND.getCode());
        this.setHeader(HttpHeaderNames.LOCATION.getKey(), location);
        this.commit();
    }

    @Override
    public void sendError(int status) {
        this.check();
        this.setStatus(status);
        this.commit();
    }

    @Override
    public void sendError(int status, String message) {
        this.check();
        this.setStatus(status);
        this.setBody(message);
        this.commit();
    }

    @Override
    public boolean isEmpty() {
        return this.status == 0 && (this.headers == null || this.headers.isEmpty()) && this.isContentEmpty();
    }

    @Override
    public boolean isContentEmpty() {
        if (this.body != null) {
            return false;
        }
        if (this.outputStream != null && this.outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.outputStream).size() == 0;
        }
        return true;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public void reset() {
        this.check();
        this.headers = null;
        this.status = 0;
        this.contentType = null;
        this.body = null;
        this.resetBuffer();
    }

    @Override
    public void resetBuffer() {
        this.check();
        if (this.outputStream == null) {
            return;
        }
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
            return;
        }
        String name = this.outputStream.getClass().getName();
        throw new UnsupportedOperationException("The outputStream type [" + name + "] is not supported to reset");
    }

    private void check() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
    }

    @Override
    public HttpResult<Object> toHttpResult() {
        DefaultHttpResult.Builder builder = HttpResult.builder();
        int status = this.status;
        Object body = this.body;
        builder.headers(this.headers);
        if (body instanceof HttpResult) {
            HttpResult result = (HttpResult)body;
            if (result.getStatus() != 0) {
                status = result.getStatus();
            }
            if (result.getBody() != null) {
                body = result.getBody();
            }
            builder.headers(result.getHeaders());
        }
        return builder.status(status == 0 ? HttpStatus.OK.getCode() : status).body(body == null ? this.outputStream : body).build();
    }

    public String toString() {
        return "DefaultHttpResponse{" + this.fieldToString() + '}';
    }

    protected final String fieldToString() {
        return "status=" + this.status + ", contentType='" + this.contentType() + '\'' + ", body=" + this.body;
    }
}

