/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.restclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.RestResult;
import org.apache.dubbo.remoting.http.config.HttpClientConfig;

public class URLConnectionRestClient
implements RestClient {
    private final HttpClientConfig clientConfig;

    public URLConnectionRestClient(HttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<RestResult> send(RequestTemplate requestTemplate) {
        CompletableFuture<RestResult> future = new CompletableFuture<RestResult>();
        try {
            final HttpURLConnection connection = (HttpURLConnection)new URL(requestTemplate.getURL()).openConnection();
            connection.setConnectTimeout(this.clientConfig.getConnectTimeout());
            connection.setReadTimeout(this.clientConfig.getReadTimeout());
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(requestTemplate.getHttpMethod());
            for (String field : requestTemplate.getAllHeaders().keySet()) {
                for (String value : requestTemplate.getHeaders(field)) {
                    connection.addRequestProperty(field, value);
                }
            }
            boolean gzipEncodedRequest = requestTemplate.isGzipEncodedRequest();
            boolean deflateEncodedRequest = requestTemplate.isDeflateEncodedRequest();
            if (requestTemplate.isBodyEmpty()) {
                future.complete(new RestResult(){

                    @Override
                    public String getContentType() {
                        return connection.getContentType();
                    }

                    @Override
                    public byte[] getBody() throws IOException {
                        return IOUtils.toByteArray((InputStream)connection.getInputStream());
                    }

                    @Override
                    public Map<String, List<String>> headers() {
                        return connection.getHeaderFields();
                    }

                    @Override
                    public byte[] getErrorResponse() throws IOException {
                        return IOUtils.toByteArray((InputStream)connection.getErrorStream());
                    }

                    @Override
                    public int getResponseCode() throws IOException {
                        return connection.getResponseCode();
                    }

                    @Override
                    public String getMessage() throws IOException {
                        return connection.getResponseMessage();
                    }
                });
                return future;
            }
            Integer contentLength = requestTemplate.getContentLength();
            if (contentLength != null) {
                connection.setFixedLengthStreamingMode(contentLength);
            } else {
                connection.setChunkedStreamingMode(this.clientConfig.getChunkLength());
            }
            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            if (gzipEncodedRequest) {
                out = new GZIPOutputStream(out);
            } else if (deflateEncodedRequest) {
                out = new DeflaterOutputStream(out);
            }
            try {
                out.write(requestTemplate.getSerializedBody());
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            future.complete(new RestResult(){

                @Override
                public String getContentType() {
                    return connection.getContentType();
                }

                @Override
                public byte[] getBody() throws IOException {
                    return IOUtils.toByteArray((InputStream)connection.getInputStream());
                }

                @Override
                public Map<String, List<String>> headers() {
                    return connection.getHeaderFields();
                }

                @Override
                public byte[] getErrorResponse() throws IOException {
                    return IOUtils.toByteArray((InputStream)connection.getErrorStream());
                }

                @Override
                public int getResponseCode() throws IOException {
                    return connection.getResponseCode();
                }

                @Override
                public String getMessage() throws IOException {
                    return connection.getResponseMessage();
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void close() {
    }

    @Override
    public void close(int timeout) {
    }

    @Override
    public boolean isClosed() {
        return true;
    }
}

