/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.connection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.api.connection.ConnectionManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class SingleProtocolConnectionManager
implements ConnectionManager {
    public static final String NAME = "single";
    private final ConcurrentMap<String, AbstractConnectionClient> connections = new ConcurrentHashMap<String, AbstractConnectionClient>(16);
    private FrameworkModel frameworkModel;

    public SingleProtocolConnectionManager(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public AbstractConnectionClient connect(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        return this.connections.compute(url.getAddress(), (address, conn) -> {
            if (conn == null) {
                String transport = url.getParameter("transporter", "netty4");
                ConnectionManager manager = (ConnectionManager)this.frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension(transport);
                AbstractConnectionClient connectionClient = manager.connect(url, handler);
                connectionClient.addCloseListener(() -> this.connections.remove(address, connectionClient));
                return connectionClient;
            }
            conn.retain();
            return conn;
        });
    }

    @Override
    public void forEachConnection(Consumer<AbstractConnectionClient> connectionConsumer) {
        this.connections.values().forEach(connectionConsumer);
    }
}

