/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractServiceNameMapping;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class MetadataServiceNameMapping
extends AbstractServiceNameMapping {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    private static final List<String> IGNORED_SERVICE_INTERFACES = Collections.singletonList(MetadataService.class.getName());
    private final int casRetryTimes;
    private final int casRetryWaitTime;
    protected MetadataReportInstance metadataReportInstance;

    public MetadataServiceNameMapping(ApplicationModel applicationModel) {
        super(applicationModel);
        this.metadataReportInstance = (MetadataReportInstance)applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        this.casRetryTimes = ConfigurationUtils.getGlobalConfiguration((ScopeModel)applicationModel).getInt("dubbo.metadata-report.cas-retry-times", 10);
        this.casRetryWaitTime = ConfigurationUtils.getGlobalConfiguration((ScopeModel)applicationModel).getInt("dubbo.metadata-report.cas-retry-wait-time", 100);
    }

    public boolean map(URL url) {
        if (CollectionUtils.isEmpty((Collection)this.applicationModel.getApplicationConfigManager().getMetadataConfigs())) {
            this.logger.warn("1-1", "", "", "No valid metadata config center found for mapping report.");
            return false;
        }
        String serviceInterface = url.getServiceInterface();
        if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
            return true;
        }
        boolean result = true;
        for (Map.Entry entry : this.metadataReportInstance.getMetadataReports(true).entrySet()) {
            MetadataReport metadataReport = (MetadataReport)entry.getValue();
            String appName = this.applicationModel.getApplicationName();
            try {
                boolean succeeded;
                if (metadataReport.registerServiceAppMapping(serviceInterface, appName, url)) continue;
                int currentRetryTimes = 1;
                String newConfigContent = appName;
                do {
                    ConfigItem configItem;
                    String oldConfigContent;
                    if (StringUtils.isNotEmpty((String)(oldConfigContent = (configItem = metadataReport.getConfigItem(serviceInterface, "mapping")).getContent()))) {
                        boolean contains = StringUtils.isContains((String)oldConfigContent, (String)appName);
                        if (contains) {
                            succeeded = true;
                            break;
                        }
                        newConfigContent = oldConfigContent + "," + appName;
                    }
                    if (succeeded = metadataReport.registerServiceAppMapping(serviceInterface, "mapping", newConfigContent, configItem.getTicket())) continue;
                    int waitTime = ThreadLocalRandom.current().nextInt(this.casRetryWaitTime);
                    this.logger.info("Failed to publish service name mapping to metadata center by cas operation. Times: " + currentRetryTimes + ". Next retry delay: " + waitTime + ". Service Interface: " + serviceInterface + ". Origin Content: " + oldConfigContent + ". Ticket: " + configItem.getTicket() + ". Excepted context: " + newConfigContent);
                    Thread.sleep(waitTime);
                } while (!succeeded && currentRetryTimes++ <= this.casRetryTimes);
                if (succeeded) continue;
                result = false;
            }
            catch (Exception e) {
                result = false;
                this.logger.warn("99-0", "unknown error in registry module", "", "Failed registering mapping to remote." + metadataReport, (Throwable)e);
            }
        }
        return result;
    }

    public Set<String> get(URL url) {
        String serviceInterface = url.getServiceInterface();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        if (metadataReport == null) {
            return Collections.emptySet();
        }
        return metadataReport.getServiceAppMapping(serviceInterface, url);
    }

    public Set<String> getAndListen(URL url, MappingListener mappingListener) {
        String serviceInterface = url.getServiceInterface();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        if (metadataReport == null) {
            return Collections.emptySet();
        }
        return metadataReport.getServiceAppMapping(serviceInterface, mappingListener, url);
    }

    protected void removeListener(URL url, MappingListener mappingListener) {
        String serviceInterface = url.getServiceInterface();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        if (metadataReport == null) {
            return;
        }
        metadataReport.removeServiceAppMappingListener(serviceInterface, mappingListener);
    }

    protected String getRegistryCluster(URL url) {
        int i;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        if (registryCluster == null) {
            registryCluster = "default";
        }
        if ((i = registryCluster.indexOf(",")) > 0) {
            registryCluster = registryCluster.substring(0, i);
        }
        return registryCluster;
    }
}

