/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.generate.JarScanner;

public class ResourceScanner
extends JarScanner {
    private static final String DUBBO_INTERNAL_RESOURCE_DIRECTORY = "META-INF/dubbo/internal/";
    private static final String DUBBO_RESOURCE_DIRECTORY = "META-INF/dubbo/";
    private static final String SERVICES_RESOURCE_DIRECTORY = "META-INF/services/";
    private static final String SECURITY_RESOURCE_DIRECTORY = "security/";
    public static final ResourceScanner INSTANCE = new ResourceScanner();

    public Set<String> distinctSpiResource() {
        return this.getResourcePath().stream().distinct().filter(this::matchedSpiResource).collect(Collectors.toSet());
    }

    public Set<String> distinctSecurityResource() {
        return this.getResourcePath().stream().distinct().filter(this::matchedSecurityResource).collect(Collectors.toSet());
    }

    private boolean matchedSecurityResource(String path) {
        return path.startsWith(SECURITY_RESOURCE_DIRECTORY);
    }

    private boolean matchedSpiResource(String path) {
        return path.startsWith(DUBBO_INTERNAL_RESOURCE_DIRECTORY) || path.startsWith(DUBBO_RESOURCE_DIRECTORY) || path.startsWith(SERVICES_RESOURCE_DIRECTORY);
    }
}

