/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.RegistryMetricsConstants;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryStatComposite
extends AbstractMetricsExport {
    private final Map<MetricsKey, Map<ApplicationMetric, AtomicLong>> appStats = new ConcurrentHashMap<MetricsKey, Map<ApplicationMetric, AtomicLong>>();

    public RegistryStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
        this.init(RegistryMetricsConstants.REGISTER_LEVEL_KEYS);
    }

    public void init(List<MetricsKey> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return;
        }
        appKeys.forEach(appKey -> {
            Map cfr_ignored_0 = this.appStats.put((MetricsKey)appKey, new ConcurrentHashMap());
        });
    }

    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (MetricsKey metricsKey : this.appStats.keySet()) {
            Map<ApplicationMetric, AtomicLong> stringAtomicLongMap = this.appStats.get(metricsKey);
            for (ApplicationMetric registerKeyMetric : stringAtomicLongMap.keySet()) {
                list.add((MetricSample)new GaugeMetricSample(metricsKey, registerKeyMetric.getTags(), category, stringAtomicLongMap, value -> ((AtomicLong)value.get(registerKeyMetric)).get()));
            }
        }
        return list;
    }

    public void incrMetricsNum(MetricsKey metricsKey, String name) {
        if (!this.appStats.containsKey(metricsKey)) {
            return;
        }
        ApplicationMetric applicationMetric = new ApplicationMetric(this.getApplicationModel());
        applicationMetric.setExtraInfo(Collections.singletonMap("REGISTRY_CLUSTER".toLowerCase(), name));
        this.appStats.get(metricsKey).computeIfAbsent(applicationMetric, k -> new AtomicLong(0L)).getAndAdd(1L);
        MetricsSupport.fillZero(this.appStats);
    }

    public Map<MetricsKey, Map<ApplicationMetric, AtomicLong>> getAppStats() {
        return this.appStats;
    }
}

