/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.registry.collector.stat.RegistryStatComposite;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;

public class MetricsNotifyListener
implements MetricsLifeListener<RegistryEvent.MetricsNotifyEvent> {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());

    public boolean isSupport(MetricsEvent event) {
        return event instanceof RegistryEvent.MetricsNotifyEvent;
    }

    public void onEvent(RegistryEvent.MetricsNotifyEvent event) {
        event.getCollector().increment(event.getSource().getApplicationName(), RegistryEvent.Type.N_TOTAL);
    }

    public void onEventFinish(RegistryEvent.MetricsNotifyEvent event) {
        event.getCollector().setNum(RegistryEvent.Type.N_LAST_NUM, event.getSource().getApplicationName(), event.getLastNotifyNum());
        event.getCollector().addRT(event.getSource().getApplicationName(), RegistryStatComposite.OP_TYPE_NOTIFY, event.getTimePair().calc());
    }

    public void onEventError(RegistryEvent.MetricsNotifyEvent event) {
    }
}

