/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.metadata.MetadataMetricsConstants;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.metrics.metadata.event.MetadataSubDispatcher;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MetadataMetricsCollector
extends CombMetricsCollector<MetadataEvent> {
    private Boolean collectEnabled = null;
    private final ApplicationModel applicationModel;

    public MetadataMetricsCollector(ApplicationModel applicationModel) {
        super(new BaseStatComposite(applicationModel){

            protected void init(ApplicationStatComposite applicationStatComposite) {
                super.init(applicationStatComposite);
                applicationStatComposite.init(MetadataMetricsConstants.APP_LEVEL_KEYS);
            }

            protected void init(ServiceStatComposite serviceStatComposite) {
                super.init(serviceStatComposite);
                serviceStatComposite.initWrapper(MetadataMetricsConstants.SERVICE_LEVEL_KEYS);
            }

            protected void init(RtStatComposite rtStatComposite) {
                super.init(rtStatComposite);
                rtStatComposite.init(new MetricsPlaceValue[]{MetadataMetricsConstants.OP_TYPE_PUSH, MetadataMetricsConstants.OP_TYPE_SUBSCRIBE, MetadataMetricsConstants.OP_TYPE_STORE_PROVIDER_INTERFACE});
            }
        });
        super.setEventMulticaster((MetricsEventMulticaster)new MetadataSubDispatcher(this));
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableMetadata()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(super.export(MetricsCategory.METADATA));
        return list;
    }

    public boolean calSamplesChanged() {
        return this.stats.calSamplesChanged();
    }
}

