/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;

public class ServiceKeyMetric
implements Metric {
    private final String applicationName;
    private final String serviceKey;

    public ServiceKeyMetric(String applicationName, String serviceKey) {
        this.applicationName = applicationName;
        this.serviceKey = serviceKey;
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("interface", this.serviceKey);
        return tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKeyMetric that = (ServiceKeyMetric)o;
        if (!this.applicationName.equals(that.applicationName)) {
            return false;
        }
        return this.serviceKey.equals(that.serviceKey);
    }

    public int hashCode() {
        int result = this.applicationName.hashCode();
        result = 31 * result + this.serviceKey.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceKeyMetric{applicationName='" + this.applicationName + '\'' + ", serviceKey='" + this.serviceKey + '\'' + '}';
    }
}

