/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class MetricsEvent {
    protected transient ApplicationModel source;
    private boolean available = true;
    protected TypeWrapper typeWrapper;

    public MetricsEvent(ApplicationModel source) {
        if (source == null) {
            this.source = ApplicationModel.defaultModel();
            this.available = false;
        } else {
            this.source = source;
        }
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void customAfterPost(Object postResult) {
    }

    public ApplicationModel getSource() {
        return this.source;
    }

    public boolean isAssignableFrom(Object type) {
        return this.typeWrapper.isAssignableFrom(type);
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "]";
    }

    public static enum Type {
        TOTAL("TOTAL_%s"),
        SUCCEED("SUCCEED_%s"),
        BUSINESS_FAILED("BUSINESS_FAILED_%s"),
        REQUEST_TIMEOUT("REQUEST_TIMEOUT_%s"),
        REQUEST_LIMIT("REQUEST_LIMIT_%s"),
        PROCESSING("PROCESSING_%s"),
        UNKNOWN_FAILED("UNKNOWN_FAILED_%s"),
        TOTAL_FAILED("TOTAL_FAILED_%s"),
        APPLICATION_INFO("APPLICATION_INFO_%s"),
        NETWORK_EXCEPTION("NETWORK_EXCEPTION_%s"),
        SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE_%s"),
        CODEC_EXCEPTION("CODEC_EXCEPTION_%s");

        private String name;

        public final String getName() {
            return this.name;
        }

        public final String getNameByType(String type) {
            return String.format(this.name, type);
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

