/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.metadata.store.nacos.NacosConfigServiceWrapper;
import org.apache.dubbo.rpc.RpcException;

public class NacosMetadataReport
extends AbstractMetadataReport {
    private NacosConfigServiceWrapper configService;
    private Gson gson = new Gson();
    private String group;

    public NacosMetadataReport(URL url) {
        super(url);
        this.configService = this.buildConfigService(url);
        this.group = url.getParameter("group", "dubbo");
    }

    public NacosConfigServiceWrapper buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = new NacosConfigServiceWrapper(NacosFactory.createConfigService((Properties)nacosProperties));
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        NacosMetadataReport.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        Map parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll((Map<?, ?>)parameters);
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String content = this.gson.toJson((Object)metadataInfo);
        try {
            this.configService.publishConfig(identifier.getApplication(), identifier.getRevision(), content);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        try {
            String content = this.configService.getConfig(identifier.getApplication(), identifier.getRevision(), 3000L);
            return (MetadataInfo)this.gson.fromJson(content, MetadataInfo.class);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata((BaseMetadataIdentifier)providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata((BaseMetadataIdentifier)consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier, URL.encode((String)url.toFullString()));
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier);
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getConfig((BaseMetadataIdentifier)metadataIdentifier);
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier, urlListStr);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getConfig((BaseMetadataIdentifier)subscriberMetadataIdentifier);
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getConfig((BaseMetadataIdentifier)metadataIdentifier);
    }

    private void storeMetadata(BaseMetadataIdentifier identifier, String value) {
        try {
            boolean publishResult = this.configService.publishConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, value);
            if (!publishResult) {
                throw new RuntimeException("publish nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
            throw new RpcException("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier identifier) {
        try {
            boolean publishResult = this.configService.removeConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group);
            if (!publishResult) {
                throw new RuntimeException("remove nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }

    private String getConfig(BaseMetadataIdentifier identifier) {
        try {
            return this.configService.getConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, 3000L);
        }
        catch (Throwable t) {
            this.logger.error("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }
}

