/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.integration;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.store.MetadataReport;
import org.apache.dubbo.metadata.store.MetadataReportFactory;
import org.apache.dubbo.rpc.RpcException;

public class MetadataReportService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static MetadataReportService metadataReportService;
    private static Object lock;
    private MetadataReportFactory metadataReportFactory = (MetadataReportFactory)ExtensionLoader.getExtensionLoader(MetadataReportFactory.class).getAdaptiveExtension();
    MetadataReport metadataReport;
    URL metadataReportUrl;

    MetadataReportService(URL metadataReportURL) {
        if ("metadata".equals(metadataReportURL.getProtocol())) {
            String protocol = metadataReportURL.getParameter("metadata", "dubbo");
            metadataReportURL = metadataReportURL.setProtocol(protocol).removeParameter("metadata");
        }
        this.metadataReportUrl = metadataReportURL;
        this.metadataReport = this.metadataReportFactory.getMetadataReport(this.metadataReportUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataReportService instance(Supplier<URL> metadataReportUrl) {
        if (metadataReportService == null) {
            Object object = lock;
            synchronized (object) {
                if (metadataReportService == null) {
                    URL metadataReportURLTmp = metadataReportUrl.get();
                    if (metadataReportURLTmp == null) {
                        return null;
                    }
                    metadataReportService = new MetadataReportService(metadataReportURLTmp);
                }
            }
        }
        return metadataReportService;
    }

    public void publishProvider(URL providerUrl) throws RpcException {
        providerUrl = providerUrl.removeParameters(new String[]{"pid", "timestamp", "bind.ip", "bind.port", "timestamp"});
        try {
            String interfaceName = providerUrl.getParameter("interface");
            if (StringUtils.isNotEmpty((String)interfaceName)) {
                Class<?> interfaceClass = Class.forName(interfaceName);
                FullServiceDefinition fullServiceDefinition = ServiceDefinitionBuilder.buildFullDefinition(interfaceClass, (Map)providerUrl.getParameters());
                this.metadataReport.storeProviderMetadata(new MetadataIdentifier(providerUrl.getServiceInterface(), providerUrl.getParameter("version"), providerUrl.getParameter("group"), "provider", providerUrl.getParameter("application")), fullServiceDefinition);
                return;
            }
            this.logger.error("publishProvider interfaceName is empty . providerUrl: " + providerUrl.toFullString());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("publishProvider getServiceDescriptor error. providerUrl: " + providerUrl.toFullString(), (Throwable)e);
        }
    }

    public void publishConsumer(URL consumerURL) throws RpcException {
        consumerURL = consumerURL.removeParameters(new String[]{"pid", "timestamp", "bind.ip", "bind.port", "timestamp"});
        this.metadataReport.storeConsumerMetadata(new MetadataIdentifier(consumerURL.getServiceInterface(), consumerURL.getParameter("version"), consumerURL.getParameter("group"), "consumer", consumerURL.getParameter("application")), consumerURL.getParameters());
    }

    static {
        lock = new Object();
    }
}

