/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.lang.reflect.Parameter;
import java.util.Set;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.NoAnnotatedParameterRequestTagProcessor;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;

public abstract class AbstractNoAnnotatedParameterProcessor
implements NoAnnotatedParameterRequestTagProcessor {
    @Override
    public void process(Parameter parameter, int parameterIndex, RestMethodMetadata restMethodMetadata) {
        MediaType mediaType = this.consumerContentType();
        if (!this.contentTypeSupport(restMethodMetadata, mediaType, parameter.getType())) {
            return;
        }
        boolean isFormBody = this.isFormContentType(restMethodMetadata);
        this.addArgInfo(parameter, parameterIndex, restMethodMetadata, isFormBody);
    }

    private boolean contentTypeSupport(RestMethodMetadata restMethodMetadata, MediaType mediaType, Class paramType) {
        if (mediaType.equals((Object)MediaType.ALL_VALUE) && (String.class == paramType || Number.class.isAssignableFrom(paramType))) {
            return true;
        }
        Set<String> consumes = restMethodMetadata.getRequest().getConsumes();
        for (String consume : consumes) {
            if (!consume.contains(mediaType.value)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFormContentType(RestMethodMetadata restMethodMetadata) {
        return false;
    }

    protected void addArgInfo(Parameter parameter, int parameterIndex, RestMethodMetadata restMethodMetadata, boolean isFormBody) {
        ArgInfo argInfo = ArgInfo.build(parameterIndex, parameter).setParamAnnotationType(ClassUtils.resolveClass((String)this.defaultAnnotationClassName(restMethodMetadata), (ClassLoader)ClassUtils.getClassLoader())).setAnnotationNameAttribute(parameter.getName()).setFormContentType(isFormBody);
        restMethodMetadata.addArgInfo(argInfo);
    }
}

